package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitDisplayConfigReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitDisplayConfigRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitDisplayConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访(陈列执行配置) 
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitdisplayconfig")
@Api(tags = "拜访(陈列执行配置) ")
public class SfaVisitDisplayConfigController {
    @Resource
    private ISfaVisitDisplayConfigService sfaVisitDisplayConfigService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmAPIDiscard
    public Result<PageResult<SfaVisitDisplayConfigRespVo>> list(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        PageResult<SfaVisitDisplayConfigRespVo> result=sfaVisitDisplayConfigService.findList(sfaVisitDisplayConfigReqVo);
        return Result.ok(result);
    }

    /**
     * 查询有效数据
     */
    @ApiOperation(value = "查询有效配置数据")
    @PostMapping("/getConfig")
    @CrmLog
    @CrmAPIDiscard
    public Result<List<SfaVisitDisplayConfigRespVo>> getConfig(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo){
        List<SfaVisitDisplayConfigRespVo> sfaVisitDisplayConfigRespVos = sfaVisitDisplayConfigService.getConfig(sfaVisitDisplayConfigReqVo);
        return Result.ok(sfaVisitDisplayConfigRespVos);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmAPIDiscard
    public Result<SfaVisitDisplayConfigRespVo> query(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        SfaVisitDisplayConfigRespVo respVo=sfaVisitDisplayConfigService.query(sfaVisitDisplayConfigReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    @CrmAPIDiscard
    public Result save(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        sfaVisitDisplayConfigService.save(sfaVisitDisplayConfigReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @CrmAPIDiscard
    public Result update(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        sfaVisitDisplayConfigService.update(sfaVisitDisplayConfigReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    @CrmAPIDiscard
    public Result delete(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        sfaVisitDisplayConfigService.deleteBatch(sfaVisitDisplayConfigReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    @CrmAPIDiscard
    public Result enable(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        sfaVisitDisplayConfigService.enableBatch(sfaVisitDisplayConfigReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    @CrmAPIDiscard
    public Result disable(@RequestBody  SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        sfaVisitDisplayConfigService.disableBatch(sfaVisitDisplayConfigReqVo);
        return Result.ok("禁用成功");
    }
}
