package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionTypeReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionTypeRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 拜访步骤(活动执行要求);
 *
 * @author lf
 * @date 2020-12-30 19:45:13
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepactivityexecutiontype")
@Api(tags = "拜访步骤(活动执行要求);")
public class SfaVisitStepActivityExecutionTypeController {
    @Resource
    private ISfaVisitStepActivityExecutionTypeService sfaVisitStepActivityExecutionTypeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitStepActivityExecutionTypeRespVo>> list(@RequestBody SfaVisitStepActivityExecutionTypeReqVo sfaVisitStepActivityExecutionTypeReqVo) {
        PageResult<SfaVisitStepActivityExecutionTypeRespVo> result=sfaVisitStepActivityExecutionTypeService.findList(sfaVisitStepActivityExecutionTypeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitStepActivityExecutionTypeRespVo> query(@RequestBody SfaVisitStepActivityExecutionTypeReqVo sfaVisitStepActivityExecutionTypeReqVo) {
        SfaVisitStepActivityExecutionTypeRespVo respVo=sfaVisitStepActivityExecutionTypeService.query(sfaVisitStepActivityExecutionTypeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitStepActivityExecutionTypeReqVo sfaVisitStepActivityExecutionTypeReqVo) {
        sfaVisitStepActivityExecutionTypeService.save(sfaVisitStepActivityExecutionTypeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitStepActivityExecutionTypeReqVo sfaVisitStepActivityExecutionTypeReqVo) {
        sfaVisitStepActivityExecutionTypeService.update(sfaVisitStepActivityExecutionTypeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaVisitStepActivityExecutionTypeReqVo sfaVisitStepActivityExecutionTypeReqVo) {
        sfaVisitStepActivityExecutionTypeService.deleteBatch(sfaVisitStepActivityExecutionTypeReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaVisitStepActivityExecutionTypeReqVo sfaVisitStepActivityExecutionTypeReqVo) {
        sfaVisitStepActivityExecutionTypeService.enableBatch(sfaVisitStepActivityExecutionTypeReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaVisitStepActivityExecutionTypeReqVo sfaVisitStepActivityExecutionTypeReqVo) {
        sfaVisitStepActivityExecutionTypeService.disableBatch(sfaVisitStepActivityExecutionTypeReqVo);
        return Result.ok("禁用成功");
    }
}
