package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepFromReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepFromSearchReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromListRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访步骤表单配置
 * @author YuanZiJian
 * @date 2021/2/5 15:47
 * @version: V1.0
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitStepFromController")
@Api(tags = "拜访步骤表单配置——Web")
public class SfaVisitStepFromController {
    @Resource
    ISfaVisitStepFromService iSfaVisitStepFromService;

    /**
     *
     * 拜访步骤表单—— 分页查询步骤表单列表
     * @method queryList
     * @date: 2021/2/5 15:55
     * @author: YuanZiJian
     * @param sfaVisitStepFromSearchReqVo
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromListRespVo>>
     */
    @ApiOperation(value = "拜访步骤表单列表")
    @PostMapping("/queryStepFromList")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaVisitStepFromListRespVo>> queryStepFromList(@RequestBody SfaVisitStepFromSearchReqVo sfaVisitStepFromSearchReqVo) {
        return Result.ok(iSfaVisitStepFromService.queryList(sfaVisitStepFromSearchReqVo));
    }

    /**
     *
     * 根据主键Id查询拜访步骤表单详情
     * @method queryList
     * @date: 2021/2/5 15:55
     * @author: YuanZiJian
     * @param id 主键Id
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromListRespVo>>
     */
    @ApiOperation(value = "拜访步骤表单详情—通过Id")
    @GetMapping("/queryStepFromById")
    @CrmLog
    @CrmDictMethod
    public Result<SfaVisitStepFromRespVo> queryStepFromById(@RequestParam(required = false) String id) {
        SfaVisitStepFromRespVo fromRespVo = this.iSfaVisitStepFromService.queryById(id);
        if(null == fromRespVo){
            throw new BusinessException("未查询到表单配置数据");
        }
        return Result.ok(fromRespVo);
    }

    /**
     * 拜访步骤表单—— 新增和编辑
     * @method queryList
     * @date: 2021/2/5 15:58
     * @author: YuanZiJian
     * @param sfaVisitStepFromReqVo 接收步骤表单新增修改信息Vo
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromListRespVo>>
     */
    @ApiOperation(value = "拜访步骤表单—— 新增和编辑")
    @PostMapping("/saveOrUpdateStepFrom")
    @CrmLog
    public Result saveOrUpdateStepFrom(@RequestBody SfaVisitStepFromReqVo sfaVisitStepFromReqVo) {
        iSfaVisitStepFromService.saveOrUpdate(sfaVisitStepFromReqVo);
        return Result.ok();
    }
    
    /**
     * 拜访步骤表单—— 删除（批量）——被禁用后的数据才能删除
     * @method deleteStepFromBatch
     * @date: 2021/2/5 16:05
     * @author: YuanZiJian
     * @param ids
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "拜访步骤表单—— 删除（批量）——被禁用后的数据才能删除")
    @PostMapping("/deleteStepFromBatch")
    @CrmLog
    public Result deleteStepFromBatch(@RequestBody List<String> ids) {
        iSfaVisitStepFromService.deleteBatch(ids);
        return Result.ok();
    }

    /**
     * 拜访步骤表单—— 启用（批量)
     * @method deleteStepFromBatch
     * @date: 2021/2/5 16:06
     * @author: YuanZiJian
     * @param ids
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "拜访步骤表单—— 启用（批量)")
    @PostMapping("/enableStepFromBatch")
    @CrmLog
    public Result enableStepFromBatch(@RequestBody List<String> ids) {
        iSfaVisitStepFromService.enableBatch(ids);
        return Result.ok();
    }


    @ApiOperation(value = "拜访步骤表单—— 禁用（批量)")
    @PostMapping("/disableStepFromBatch")
    @CrmLog
    public Result disableStepFromBatch(@RequestBody List<String> ids) {
        iSfaVisitStepFromService.disableBatch(ids);
        return Result.ok();
    }
}
