package com.biz.crm.visitstep.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStockReqVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitStepStockService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 拜访步骤(库存盘点);
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepstock")
@Api(tags = "拜访步骤(库存盘点);")
public class SfaVisitStepStockController {
    @Resource
    private ISfaVisitStepStockService sfaVisitStepStockService;



    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    @CrmAPIDiscard
    public Result save(@RequestBody SfaVisitStepStockReqVo sfaVisitStepStockReqVo) {
        sfaVisitStepStockService.save(sfaVisitStepStockReqVo);
        return Result.ok();
    }


}
