package com.biz.crm.visitstep.mapper;

import com.biz.crm.visitstep.model.SfaVisitStepColletItemEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletItemReqVo;
import java.util.List;
import java.util.Map;

/**
 * 拜访步骤(竞品采集明细) 
 * 
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
public interface SfaVisitStepColletItemMapper extends BaseMapper<SfaVisitStepColletItemEntity> {
    /**
     * 列表
     * @param sfaVisitStepColletItemReqVo
     * @return
     */
    List<SfaVisitStepColletItemRespVo> findList( @Param("vo") SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo);

    /**
     * 根据主表id查询集合
     * @param id
     * @return
     */
    List<SfaVisitStepColletItemRespVo> findListByClientId(@Param("id") String id);

    /**
     * 根据主表id查询品牌集合
     * @param collentId
     * @return
     */
    List<String> findBrands(@Param("collentId") String collentId);

    /**
     * 根据竞品品牌拿到ids
     * @param keyWord
     * @return
     */
    List<SfaVisitStepColletItemRespVo> gainIdsByColletId(@Param("ids") List<String> colletIds, @Param("keyWord") String keyWord);

}
