package com.biz.crm.visitstep.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderDetailReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderStockAnalysisReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderDetailRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderStockAnalysisRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName SfaVisitStepOrderFormMapper.java
 * @Description web端-订单管理-报表接口
 * @createTime 2021年01月12日 14:34:00
 */
public interface SfaVisitStepOrderFormMapper {

    /**
     * 订单明细
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaVisitStepOrderDetailRespVo> orderDetail(Page<SfaVisitStepOrderDetailRespVo> page, @Param("vo") SfaVisitStepOrderDetailReqVo reqVo);

    /**
     * 终端进货量分析
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaVisitStepOrderStockAnalysisRespVo> stockAnalysis(Page<SfaVisitStepOrderStockAnalysisRespVo> page, @Param("vo") SfaVisitStepOrderStockAnalysisReqVo reqVo);
}
