package com.biz.crm.visitstep.model;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;


/**
 * 活动执行-redis执行数据
 *  @author: luoqi
 *  @Date: 2021-3-6 16:13
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
public class SfaVisitStepActivityExecutionRedisData extends SfaVisitStepActivityExecutionEntity {
    public static SfaVisitStepActivityExecutionRedisData getInstance(){
        return SfaVisitStepActivityExecutionRedisData.Instance.instance;
    }
    private static  class Instance{
        private static final SfaVisitStepActivityExecutionRedisData instance = new SfaVisitStepActivityExecutionRedisData();
    }

    /**
     * 数据类型(offline-离线，online-在线)
     */
    private SfaVisitEnum.VISIT_OFF_LINE lineType;

    /**
     *redisHash
     * @param redisHashKey
     * @return
     */
    public StringJoiner redisHash(String redisHashKey, String activityType, String stepCode){
        return new StringJoiner(RedisParam.DELIMITER).add(redisHashKey).add(TABLE_NAME).add(activityType).add(stepCode);
    }



    /**
     * 组装写入redis缓存的数据
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite(){
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(new StringJoiner(RedisParam.DELIMITER).add(this.getRedisHashKey()).add(this.getActivityCode()).toString(), this);
        return redisDataForWrite;
    }


    @ApiModelProperty("销售额")
    private String salesVolume;

    @ApiModelProperty("申请金额")
    private String applyAmount;

    @ApiModelProperty("活动描述")
    private String activityDesc;

    @ApiModelProperty("上次执行时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String lastActivityTime;


    @ApiModelProperty("活动执行要求")
    private List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList;

    public void buildActivityRequireReqVoList(String activityRequire){
        if(StringUtils.isBlank(activityRequire)){
            this.setActivityRequireReqVoList(Lists.newArrayList());
        }else{
            List list = Lists.newArrayList();
            List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList = Lists.newArrayList();
            String[] activityRequires = activityRequire.split(",");
            for (String require : activityRequires) {
                ActivityStepExecuteData.ActivityRequireReqVo requireReqVo = new ActivityStepExecuteData.ActivityRequireReqVo();
                requireReqVo.setActivityRequire(require);
                requireReqVo.setActivityRequireName(SfaActivityEnum.activityRequire.GETMAP.get(require));
                requireReqVo.setPictureList(list);
                activityRequireReqVoList.add(requireReqVo);
            }
            this.setActivityRequireReqVoList(activityRequireReqVoList);
        }
    }
}
