package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访步骤(活动执行要求);实体类
 *
 * @author lf
 * @date 2020-12-30 19:45:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_activity_execution_type")
@CrmTable(name = "sfa_visit_step_activity_execution_type", tableNote = "拜访步骤(活动执行要求);")
public class SfaVisitStepActivityExecutionTypeEntity extends CrmExtTenEntity<SfaVisitStepActivityExecutionTypeEntity> {

    /**
     * 拜访步骤活动执行id
     */
    @CrmColumn(name = "step_activity_execution_id", length = 32, note = "拜访步骤活动执行id")
    private String stepActivityExecutionId;

    /**
     * 活动执行要求(0-活动照,1-门头照,2-陈列照)
     */
    @CrmColumn(name = "activity_require", length = 5, note = "活动执行要求(0-活动照,1-门头照,2-陈列照)")
    private String activityRequire;

}
