package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.CrmObjTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import javax.persistence.Index;

/**
 * 拜访步骤(竞品采集);实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@TableName(SfaVisitStepColletEntity.TABLE_NAME)
@CrmTable(name = SfaVisitStepColletEntity.TABLE_NAME, tableNote = "拜访步骤(竞品采集);", indexes = {
        @Index(name = SfaVisitStepColletEntity.TABLE_NAME + "_index1", columnList = "step_code, client_code, pos_code, user_name, client_office_id, client_area_id")})
public class SfaVisitStepColletEntity extends CrmObjTenEntity<SfaVisitStepColletEntity> implements VisitStepListener.VisitStepListenerCommittedData {
    public static final String TABLE_NAME = "sfa_visit_step_collet";

    @CrmColumn(name = "redis_hash_key")
    private String redisHashKey;

    @ApiModelProperty("表单id")
    @CrmColumn(name = "form_id",length = 32, note = "表单id")
    @Field(type = FieldType.Keyword)
    private String formId;

    @CrmColumn(name = "visit_plan_info_id", length = 64, note = "拜访计划明细id")
    @Field(type = FieldType.Keyword)
    private String visitPlanInfoId;

    @ApiModelProperty("步骤编码")
    @CrmColumn(name = "step_code", length = 64, note = "步骤编码")
    private String stepCode;

    /**
     * 网点编码(网点即终端)
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码(网点即终端)")
    private String clientCode;

    /**
     * 网点名称(网点即终端)
     */
    @CrmColumn(name = "client_name", length = 32, note = "网点名称(网点即终端)")
    private String clientName;

    /**
     * 网点类型;协访网点类型
     */
    @CrmColumn(name = "client_type_name", length = 32, note = "网点类型 协访网点类型")
    private String clientTypeName;

    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;

    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

    /**
     * 网点类型(网点即终端)
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型(网点即终端)")
    private String clientType;

//    /**
//     * 活动名称
//     */
//    private String activityName;
    /**
     * 活动信息
     */
    @CrmColumn(name = "activity_info", note = "活动信息")
    private String activityInfo;
    /**
     * 终端区域Id
     */
    @CrmColumn(name = "client_area_id", length = 32, note = "终端区域Id")
    private String clientAreaId;

    /**
     * 终端区域
     */
    @CrmColumn(name = "client_area", length = 32, note = "终端区域")
    private String clientArea;


    /**
     * 终端所属办事处Id
     */
    @CrmColumn(name = "client_office_id", length = 32, note = "终端所属办事处Id")
    private String clientOfficeId;


    /**
     * 终端所属办事处
     */
    @CrmColumn(name = "client_office", length = 32, note = "终端所属办事处")
    private String clientOffice;

    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 32, note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 32, note = "人员姓名")
    private String realName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 32, note = "职位编码")
    private String posCode;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 32, note = "职位名称")
    private String posName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 32, note = "组织名称")
    private String orgName;

}
