package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.CrmObjTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 拜访步骤(竞品采集明细) 实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_collet_item")
@CrmTable(name = "sfa_visit_step_collet_item", tableNote = "拜访步骤(竞品采集明细)", indexes = {
        @Index(name = "sfa_visit_step_collet_item_index1", columnList = "collet_id"),
        @Index(name = "sfa_visit_step_collet_item_index2", columnList = "brand, series, product_code")})
public class SfaVisitStepColletItemEntity extends CrmObjTenEntity<SfaVisitStepColletItemEntity> {

    /**
     * 竞品主表id
     */
    @CrmColumn(name = "collet_id", length = 32, note = "竞品主表id")
    private String colletId;

    /**
     * 竞品品牌
     */
    @CrmColumn(name = "brand", length = 100, note = "竞品品牌")
    private String brand;

    /**
     * 竞品系列
     */
    @CrmColumn(name = "series", length = 100, note = "竞品系列")
    private String series;

    /**
     * 竞品产品编码
     */
    @CrmColumn(name = "product_code", length = 512, note = "竞品产品编码")
    private String productCode;

    /**
     * 竞品产品名称
     */
    @CrmColumn(name = "product_name", length = 200, note = "竞品产品名称")
    private String productName;

    /**
     * 铺货数量
     */
    @CrmColumn(name = "quantity", mysqlType = "decimal(6,2)", oracleType = "NUMBER(6,2)", note = "铺货数量")
    private BigDecimal quantity;

    /**
     * 单位
     */
    @CrmColumn(name = "unit", length = 32, note = "单位")
    private String unit;

    @CrmColumn(name = "batch_price", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "竞品批发价")
    private BigDecimal batchPrice;

    @CrmColumn(name = "price", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "竞品销售价")
    private BigDecimal price;

}
