package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 竞品商品 实体类
 *
 * @author hej
 * @date 2020-11-23 15:58:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_collet_product")
@CrmTable(name = "sfa_visit_step_collet_product", tableNote = "竞品商品")
public class SfaVisitStepColletProductEntity extends CrmExtTenEntity<SfaVisitStepColletProductEntity> {

    /**
     * 品牌名称
     */
    @CrmColumn(name = "brand_name", length = 32, note = "品牌名称")
    private String brandName;

    /**
     * 品牌编码
     */
    @CrmColumn(name = "brand_code", length = 32, note = "品牌编码")
    private String brandCode;

    /**
     * 所属系列
     */
    @CrmColumn(name = "series_name", length = 32, note = "所属系列")
    private String seriesName;

    /**
     * 所属系列编码
     */
    @CrmColumn(name = "series_code", length = 32, note = "所属系列编码")
    private String seriesCode;

    /**
     * 竞品名称
     */
    @CrmColumn(name = "product_name", length = 32, note = "竞品名称")
    private String productName;

    /**
     * 竞品商品编码
     */
    @CrmColumn(name = "contend_product_code", length = 32, note = "竞品商品编码")
    private String contendProductCode;


}
