package com.biz.crm.visitstep.model;

import com.biz.crm.common.param.RedisParam;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.Setter;

import java.util.Map;
import java.util.StringJoiner;


/**
 * 默认步骤模板
 *  @author: luoqi
 *  @Date: 2021-3-22 21:12
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
@ApiModel("默认步骤模板实体-redis")
public class SfaVisitStepDefaultRedisData extends SfaVisitStepDefaultEntity {
    public static SfaVisitStepDefaultRedisData getInstance(){
        return SfaVisitStepDefaultRedisData.Instance.instance;
    }
    private static  class Instance{
        private static final SfaVisitStepDefaultRedisData instance = new SfaVisitStepDefaultRedisData();
    }
    /**
     *redisHash
     * @param redisHashKey
     * @return
     */
    public StringJoiner redisHash(String redisHashKey, String stepCode){
        return new StringJoiner(RedisParam.DELIMITER).add(redisHashKey).add(TABLE_NAME).add(stepCode);
    }

    /**
     * 组装写入redis缓存的数据
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite(){
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }



}
