package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访步骤表单控件_实体
 *
 * @author YuanZiJian
 * @date 2021/2/4 10:29
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName(value = "sfa_step_form_control")
@CrmTable(name = "sfa_step_form_control", tableNote = "拜访步骤表单控件")
public class SfaVisitStepFromControlEntity extends CrmExtTenEntity {

    /**
     * 关联模块的Id
     */
    @CrmColumn(name = "model_id", length = 32, note = "关联模块的Id")
    private String modelId;
    /**
     * 控件名称
     */
    @CrmColumn(name = "control_name", length = 60, note = "控件名称")
    private String controlName;
    /**
     * 控件类型
     */
    @CrmColumn(name = "control_type", length = 32, note = "控件类型")
    private String controlType;
    /**
     * 数据字典
     */
    @CrmColumn(name = "dict_code", length = 32, note = "数据字典")
    private String dictCode;
    /**
     * 扩展参数
     */
    @CrmColumn(name = "extend_param", length = 2000, note = "扩展参数")
    private String extendParam;

    /**
     * 是否必填（Yes/No）
     */
    @CrmColumn(name = "require_type", length = 10, note = "是否必填（Yes/No）")
    private String requireType;
    /**
     * 排序
     */
    @CrmColumn(name = "sort", mysqlType = "int(10)" , oracleType = "NUMBER(10,0)", note = "排序")
    private String sort;
    /**
     * 字段名
     */
    @CrmColumn(name = "field_name", length = 32, note = "字段名")
    private String fieldName;
}
