package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import javax.persistence.Index;
import java.math.BigDecimal;


/**
 * 拜访步骤(协访评价明细);实体类
 *  @author: luoqi
 *  @Date: 2021-4-20 14:16
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
@TableName(SfaVisitStepHelpScoreDetailEntity.TABLE_NAME)
@CrmTable(name = SfaVisitStepHelpScoreDetailEntity.TABLE_NAME, tableNote = "拜访步骤(协访评价明细);", indexes = {
        @Index(name = SfaVisitStepHelpScoreDetailEntity.TABLE_NAME + "_index1", columnList = "help_score_id"),
        @Index(name = SfaVisitStepHelpScoreDetailEntity.TABLE_NAME + "_index2", columnList = "step_code")})
@ApiModel("拜访步骤(协访评价明细)")
public class SfaVisitStepHelpScoreDetailEntity extends CrmExtTenEntity<SfaVisitStepHelpScoreDetailEntity>{
    public static final String TABLE_NAME = "sfa_visit_step_help_score_detail";

    @CrmColumn(name = "help_score_id", length = 32, note = "协访评价id")
    private String helpScoreId;

    @CrmColumn(name = "icon", note = "步骤图标")
    private String icon;

    @CrmColumn(name = "step_code", length = 128, note = "步骤编码")
    private String stepCode;

    @CrmColumn(name = "step_name", length = 128, note = "步骤名称")
    private String stepName;

    @CrmColumn(name = "qualified", length = 2, note = "合格/不合格")
    private String qualified;

    @CrmColumn(name = "qualified_name", length = 10, note = "合格/不合格")
    private String qualifiedName;

    @CrmColumn(name = "score", mysqlType = "decimal(6,2)", oracleType = "NUMBER(6,2)", note = "步骤评分")
    private BigDecimal score;

    @CrmColumn(name = "sort", mysqlType = "int(9)", oracleType = "NUMBER(9,0)", note = "排列顺序")
    private Integer sort;
}
