package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import javax.persistence.Index;
import java.math.BigDecimal;


/**
 * 拜访步骤(协访评价);实体类
 *  @author: luoqi
 *  @Date: 2021-4-20 14:16
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
@TableName(SfaVisitStepHelpScoreEntity.TABLE_NAME)
@CrmTable(name = SfaVisitStepHelpScoreEntity.TABLE_NAME, tableNote = "拜访步骤(协访评价);", indexes = {
        @Index(name = SfaVisitStepHelpScoreEntity.TABLE_NAME + "_index1", columnList = "step_code, client_code, pos_code, user_name, org_code"),
        @Index(name = SfaVisitStepHelpScoreEntity.TABLE_NAME + "_index2", columnList = "score_date")})
@ApiModel("拜访步骤(协访评价)")
public class SfaVisitStepHelpScoreEntity extends CrmExtTenEntity<SfaVisitStepHelpScoreEntity> implements VisitStepListener.VisitStepListenerCommittedData {
    public static final String TABLE_NAME = "sfa_visit_step_help_score";

    @CrmColumn(name = "redis_hash_key")
    private String redisHashKey;

    @ApiModelProperty("表单id")
    @CrmColumn(name = "form_id", length = 32, note = "表单id")
    @Field(type = FieldType.Keyword)
    private String formId;

    @CrmColumn(name = "visit_plan_info_id", length = 64, note = "拜访计划明细id")
    @Field(type = FieldType.Keyword)
    private String visitPlanInfoId;

    @ApiModelProperty("步骤编码")
    @CrmColumn(name = "step_code", length = 64, note = "步骤编码")
    private String stepCode;

    /**
     * 网点编码
     */
    @ApiModelProperty("网点编码")
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @ApiModelProperty("网点名称")
    @CrmColumn(name = "client_name", length = 200, note = "网点名称")
    private String clientName;

    /**
     * 网点类型
     */
    @ApiModelProperty("网点类型")
    @CrmColumn(name = "client_type", length = 32, note = "网点类型")
    private String clientType;

    /**
     * 网点类型;协访网点类型
     */
    @ApiModelProperty("网点类型")
    @CrmColumn(name = "client_type_name", length = 32, note = "网点类型 协访网点类型")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

    @ApiModelProperty("评价时间")
    @CrmColumn(name = "score_time", length = 32, note = "评价时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String scoreTime;

    @CrmColumn(name = "score_date", length = 16, note = "评价日期")
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String scoreDate;

    @CrmColumn(name = "score_year_month", length = 8, note = "评价年月")
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String scoreYearMonth;

    @CrmColumn(name = "score_year", length = 4, note = "评价年份")
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String scoreYear;

    @CrmColumn(name = "help_defense_summary", note = "协访总结")
    private String helpDefenseSummary;

    @CrmColumn(name = "key_questions", note = "重点问题记录")
    private String keyQuestions;

    @CrmColumn(name = "score", mysqlType = "decimal(6,2)", oracleType = "NUMBER(6,2)", note = "协访总评分")
    private BigDecimal score;

    /**
     * 人员账号
     */
    @ApiModelProperty("人员账号")
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @ApiModelProperty("人员姓名")
    @CrmColumn(name = "real_name", length = 50, note = "人员姓名")
    private String realName;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    @CrmColumn(name = "pos_name", length = 50, note = "职位名称")
    private String posName;

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    @CrmColumn(name = "org_name", length = 50, note = "组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;


    /**
     * 协访主键id
     */
    @CrmColumn(name = "help_Defense_Id", length = 32, note = "协访主键id")
    @Field(type = FieldType.Keyword)
    private String helpDefenseId;

    /**
     * 被协访人员账号
     */
    @CrmColumn(name = "cover_help_user_name", length = 50, note = "被协访人员账号")
    private String coverHelpUserName;

    /**
     * 被协访人员姓名
     */
    @CrmColumn(name = "cover_help_real_name", length = 50, note = "被协访人员姓名")
    private String coverHelpRealName;

    /**
     * 被协访组织编码
     */
    @CrmColumn(name = "cover_help_org_code", length = 50, note = "被协访组织编码")
    private String coverHelpOrgCode;

    /**
     * 被协访组织名称
     */
    @CrmColumn(name = "cover_help_org_name", length = 50, note = "被协访组织名称")
    private String coverHelpOrgName;

    /**
     * 被协访职位编码
     */
    @CrmColumn(name = "cover_help_pos_code", length = 50, note = "被协访职位编码")
    private String coverHelpPosCode;

    /**
     * 被协访职位名称
     */
    @CrmColumn(name = "cover_help_pos_name", length = 50, note = "被协访职位名称")
    private String coverHelpPosName;

}
