package com.biz.crm.visitstep.model;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

/**
 * 拜访步骤(协访评价);实体类
 *  @author: luoqi
 *  @Date: 2021-4-20 14:16
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
public class SfaVisitStepHelpScoreRedisData extends SfaVisitStepHelpScoreEntity {
    public static SfaVisitStepHelpScoreRedisData getInstance(){
        return SfaVisitStepHelpScoreRedisData.Instance.instance;
    }
    private static  class Instance{
        private static final SfaVisitStepHelpScoreRedisData instance = new SfaVisitStepHelpScoreRedisData();
    }

    /**
     * 数据状态(offline-离线，online-在线)
     */
    private SfaVisitEnum.VISIT_OFF_LINE lineType;
    /**
     *redisHash
     * @param redisHashKey
     * @return
     */
    public StringJoiner redisHash(String redisHashKey, String stepCode){
        return new StringJoiner(RedisParam.DELIMITER).add(redisHashKey).add(TABLE_NAME).add(stepCode);
    }

    /**
     * 组装写入redis缓存的数据
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite(){
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }

    @ApiModelProperty("评价明细明细")
    private List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList;

    @ApiModelProperty("附件容器1")
    private List<CrmAttachment> attachmentExt1;

    @ApiModelProperty("附件容器2")
    private List<CrmAttachment> attachmentExt2;

}
