package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 拜访步骤(订单主表);实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName(SfaVisitStepOrderEntity.TABLE_NAME)
@CrmTable(name = SfaVisitStepOrderEntity.TABLE_NAME, tableNote = "拜访步骤(订单主表);" , indexes = {
        @Index(name = SfaVisitStepOrderEntity.TABLE_NAME + "_index1", columnList = "step_code, client_code, pos_code, user_name, org_code"),
        @Index(name = SfaVisitStepOrderEntity.TABLE_NAME + "_index2", columnList = "order_code",unique = true),
        @Index(name = SfaVisitStepOrderEntity.TABLE_NAME + "_index3", columnList = "order_date")})
public class SfaVisitStepOrderEntity extends SfaTpmActBaseEntity<SfaVisitStepOrderEntity> {
    public static final String TABLE_NAME = "sfa_visit_step_order";

    @CrmColumn(name = "redis_hash_key")
    private String redisHashKey;

    @ApiModelProperty("表单id")
    @CrmColumn(name = "form_id", length = 32, note = "表单id")
    @Field(type = FieldType.Keyword)
    private String formId;

    @CrmColumn(name = "act_detail_code",length = 64,note = "活动编码")
    private String actDetailCode;
    /**
     * 订单编码
     */
    @CrmColumn(name = "order_code", length = 50, note = "订单编码")
    private String orderCode;

    /**
     * 下单时间
     */
    @CrmColumn(name = "order_time", length = 32, note = "下单时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String orderTime;

    /**
     * 下单时间
     */
    @CrmColumn(name = "order_date", length = 16, note = "下单日期")
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String orderDate;

    /**
     * 下单时间
     */
    @CrmColumn(name = "order_year_month", length = 8, note = "下单年月")
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String orderYearMonth;

    /**
     * 下单时间
     */
    @CrmColumn(name = "order_year", length = 4, note = "下单年份")
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String orderYear;

    /**
     * 客户图片
     */
    @CrmColumn(name = "client_photo", length = 255, note = "客户图片")
    private String clientPhoto;

    /**
     * 上级客户编码
     */
    @CrmColumn(name = "customer_code", length = 32, note = "上级客户编码")
    private String customerCode;

    /**
     * 上级客户名称
     */
    @CrmColumn(name = "customer_name", length = 200, note = "上级客户名称")
    private String customerName;

    /**
     * 联系人
     */
    @CrmColumn(name = "contacts", length = 32, note = "联系人")
    private String contacts;

    /**
     * 联系电话
     */
    @CrmColumn(name = "telephone", length = 32, note = "联系电话")
    private String telephone;

    /**
     * 收货地址
     */
    @CrmColumn(name = "address", length = 200, note = "收货地址")
    private String address;

    /**
     * 期望收货时间
     */
    @CrmColumn(name = "expect_receive", length = 32, note = "期望收货时间")
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String expectReceive;


    /**
     * 审批状态
     */
    @CrmColumn(name = "approval_status", length = 32, note = "审批状态")
    @Field(type = FieldType.Keyword)
    private String approvalStatus;
    /**
     * 审批状态
     */
    @CrmColumn(name = "approval_status_name", length = 32, note = "审批状态")
    private String approvalStatusName;
    /**
     * 工作流返回流程key
     */
    @CrmColumn(name = "process_no", length = 32, note = "工作流返回流程key")
    private String processNo;

    /**
     * 订单来源
     * 1.方案活动
     * 2.代客下单
     * 3.方案执行
     */
    @CrmColumn(name = "order_source", length = 32, note = "订单来源(方案活动 代客下单 方案执行 tpm活动)")
    @Field(type = FieldType.Keyword)
    private String orderSource;

    @CrmColumn(name = "order_source_name", length = 32, note = "订单来源(方案活动 代客下单 方案执行 tpm活动)")
    private String orderSourceName;

    /**
     * 订单总价
     */
    @CrmColumn(name = "total_price", mysqlType = "decimal(8,2)", oracleType = "NUMBER(8,2)", note = "订单总价")
    private BigDecimal totalPrice;

}
