package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 拜访步骤(订单明细);实体类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_order_item")
@CrmTable(name = "sfa_visit_step_order_item", tableNote = "拜访步骤(订单明细);",indexes = {
        @Index(name = "visit_step_order_item_index1",columnList = "order_id"),
        @Index(name = "visit_step_order_item_index2",columnList = "product_code")
})
public class SfaVisitStepOrderItemEntity extends CrmExtTenEntity<SfaVisitStepOrderItemEntity> {

    /**
     * 订单主表id
     */
    @CrmColumn(name = "order_id", length = 32, note = "订单主表id")
    private String orderId;

    @CrmColumn(name = "pic_url", note = "产品图片")
    private String picUrl;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 32, note = "产品名称")
    private String productName;

    /**
     * 产品系列编码
     */
    @CrmColumn(name = "series_code", length = 32, note = "产品系列编码")
    private String seriesCode;

    /**
     * 产品系列名称
     */
    @CrmColumn(name = "series_name", length = 32, note = "产品系列名称")
    private String seriesName;

    /**
     * 数量
     */
    @CrmColumn(name = "quantity", mysqlType = "decimal(6,2)", oracleType = "NUMBER(6,2)", note = "数量")
    private BigDecimal quantity;

    /**
     * 单位
     */
    @CrmColumn(name = "unit", length = 32, note = "单位")
    private String unit;
    /**
     * 单位
     */
    @CrmColumn(name = "unit_name", length = 32, note = "单位")
    private String unitName;

    /**
     * 商品单价
     */
    @CrmColumn(name = "price", mysqlType = "decimal(8,2)", oracleType = "NUMBER(8,2)", note = "商品单价")
    private BigDecimal price;

    /**
     * 行类型(1-本品,2-赠品)
     */
    @CrmColumn(name = "itme_type", length = 32, note = "行类型(1-本品,2-赠品)")
    private String itmeType;

    /**
     * 执行id
     */
    @CrmColumn(name = "execution_id", length = 32, note = "执行id")
    private String executionId;
    /**
     * 方案套餐id
     */
    @CrmColumn(name = "setmeal_id", length = 32, note = "方案套餐id")
    private String setmealId;

    @CrmColumn(name = "setmeal_name", length = 32, note = "方案套餐名称")
    private String setmealName;



}
