package com.biz.crm.visitstep.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.CrmObjTenEntity;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import javax.persistence.Index;
import java.util.Map;
import java.util.StringJoiner;

/**
 * 拜访步骤(店面检查);实体类
 *
 * @author lf
 * @date 2020-12-29 23:06:39
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName(SfaVisitStepStoreCheckEntity.TABLE_NAME)
@CrmTable(name = SfaVisitStepStoreCheckEntity.TABLE_NAME, tableNote = "拜访步骤(店面检查);", indexes = {
        @Index(name = SfaVisitStepStoreCheckEntity.TABLE_NAME + "_index1", columnList = "step_code, client_code, pos_code, user_name, org_code"),
        @Index(name = SfaVisitStepStoreCheckEntity.TABLE_NAME + "_index2", columnList = "check_date")})
@ApiModel("拜访步骤(店面检查)")
public class SfaVisitStepStoreCheckEntity extends CrmObjTenEntity<SfaVisitStepStoreCheckEntity> implements VisitStepListener.VisitStepListenerCommittedData {
    public static final String TABLE_NAME = "sfa_visit_step_store_check";

    @CrmColumn(name = "redis_hash_key")
    private String redisHashKey;

    @ApiModelProperty("表单id")
    @CrmColumn(name = "form_id", length = 32, note = "表单id")
    @Field(type = FieldType.Keyword)
    private String formId;

    @CrmColumn(name = "visit_plan_info_id", length = 64, note = "拜访计划明细id")
    @Field(type = FieldType.Keyword)
    private String visitPlanInfoId;

    @ApiModelProperty("步骤编码")
    @CrmColumn(name = "step_code", length = 64, note = "步骤编码")
    private String stepCode;

    /**
     * 网点编码
     */
    @ApiModelProperty("网点编码")
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @ApiModelProperty("网点名称")
    @CrmColumn(name = "client_name", length = 200, note = "网点名称")
    private String clientName;

    /**
     * 网点类型
     */
    @ApiModelProperty("网点类型")
    @CrmColumn(name = "client_type", length = 32, note = "网点类型")
    private String clientType;

    /**
     * 网点类型;协访网点类型
     */
    @ApiModelProperty("网点类型")
    @CrmColumn(name = "client_type_name", length = 32, note = "网点类型 协访网点类型")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

    /**
     * 检查时间
     */
    @ApiModelProperty("检查时间")
    @CrmColumn(name = "check_time", length = 32, note = "检查时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String checkTime;

    /**
     * 检查时间
     */
    @CrmColumn(name = "check_date", length = 16, note = "检查日期")
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String checkDate;

    /**
     * 检查时间
     */
    @CrmColumn(name = "check_year_month", length = 8, note = "检查年月")
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String checkYearMonth;

    /**
     * 检查时间
     */
    @CrmColumn(name = "check_year", length = 4, note = "检查年份")
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String checkYear;

    /**
     * 检查项(0-常规货架陈列,1-物料陈列,2-价格签)
     */
    @ApiModelProperty("检查项(0-常规货架陈列,1-物料陈列,2-价格签)")
    @CrmColumn(name = "check_type", length = 200, note = "检查项(0-常规货架陈列,1-物料陈列,2-价格签)")
    private String checkType;

    /**
     * 检查项描述(0-常规货架陈列,1-物料陈列,2-价格签)
     */
    @ApiModelProperty("检查项描述(0-常规货架陈列,1-物料陈列,2-价格签)")
    @CrmColumn(name = "check_type_desc", length = 300, note = "检查项描述(0-常规货架陈列,1-物料陈列,2-价格签)")
    private String checkTypeDesc;

    /**
     * 检查地址
     */
    @ApiModelProperty("检查地址")
    @CrmColumn(name = "check_address", length = 200, note = "检查地址")
    private String checkAddress;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    @CrmColumn(name = "longitude", length = 32, note = "经度")
    private String longitude;

    /**
     * 纬度
     */
    @ApiModelProperty("纬度")
    @CrmColumn(name = "latitude", length = 32, note = "纬度")
    private String latitude;

    /**
     * 人员账号
     */
    @ApiModelProperty("人员账号")
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @ApiModelProperty("人员姓名")
    @CrmColumn(name = "real_name", length = 50, note = "人员姓名")
    private String realName;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    @CrmColumn(name = "pos_name", length = 50, note = "职位名称")
    private String posName;

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    @CrmColumn(name = "org_name", length = 50, note = "组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;

}
