package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@Data
@ApiModel("查询竞品采集分页-参数")
public class GetColletPageReq extends VisitStepPageReq{


    @ApiModelProperty("关键字")
    private String keyWord;

    @ApiModelProperty("客户编码")
    private String clientCode;




    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not
        if(StringUtils.isBlank(this.getStepCode())){
            throw new BusinessException("请指定步骤编码");
        }
        if(StringUtils.isBlank(this.getClientCode())){
            throw new BusinessException("请指定客户编码");
        }
        builder.must(QueryBuilders.termQuery("stepCode.keyword", this.getStepCode()));
        builder.must(QueryBuilders.matchQuery("clientCode.keyword", this.getClientCode()));

        if(StringUtils.isNotBlank(this.getKeyWord())){
            QueryBuilder orderItemsQuery = QueryBuilders.nestedQuery("sfaVisitStepColletItemReqVos",
                    QueryBuilders.boolQuery()
                            .must(QueryBuilders.matchQuery("sfaVisitStepColletItemReqVos.productName", this.getKeyWord()))
                            .must(QueryBuilders.matchQuery("sfaVisitStepColletItemReqVos.productCode", this.getKeyWord())),
                    ScoreMode.Total);
            builder.must(orderItemsQuery);
        }



        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("createDate").order(SortOrder.DESC));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("createDateSecond").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
