package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

import java.time.LocalDate;
import java.util.Date;

@Data
@ApiModel("查询竞品采集报表")
public class GetColletTablePageReq extends VisitStepPageReq{

    @ApiModelProperty("客户编码")
    private String clientCode;
    @ApiModelProperty("客户名称")
    private String clientName;
    @ApiModelProperty("客户类型")
    private String clientType;
    @ApiModelProperty("提交人登录账号")
    private String createCode;
    @ApiModelProperty("人员姓名")
    private String realName;
    @ApiModelProperty("职位名称")
    private String posName;
    @ApiModelProperty("客户所属区域")
    private String clientArea;
    @ApiModelProperty("客户所属办事处")
    private String clientOffice;
    @ApiModelProperty("竞品品牌")
    private String brand;
    @ApiModelProperty("竞品系列")
    private String series;
    @ApiModelProperty("开始时间")
    private String startDate;
    @ApiModelProperty("结束时间")
    private String endDate;
    @ApiModelProperty("按月筛选")
    private String yearMonth;
    @ApiModelProperty("提交人姓名")
    private String createName;
    @ApiModelProperty("提交人职位")
    private String createPosName;



    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not
        if(StringUtils.isBlank(this.getStepCode())){
            throw new BusinessException("请指定步骤编码");
        }
        builder.must(QueryBuilders.termQuery("stepCode.keyword", this.getStepCode()));

        if(StringUtils.isNotBlank(this.getClientCode())){
            builder.must(QueryBuilders.termQuery("clientCode.keyword", this.getClientCode()));
        }
        if(StringUtils.isNotBlank(this.getClientName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientName", this.getClientName()));
        }
        if(StringUtils.isNotBlank(this.getClientType())){
            builder.must(QueryBuilders.termQuery("clientType.keyword", this.getClientType()));
        }
        if(StringUtils.isNotBlank(this.getCreateCode())){
            builder.must(QueryBuilders.termQuery("userName.keyword", this.getCreateCode()));
        }
        if(StringUtils.isNotBlank(this.getRealName())){
            builder.must(QueryBuilders.matchPhraseQuery("realName", this.getRealName()));
        }
        if(StringUtils.isNotBlank(this.getPosName())){
            builder.must(QueryBuilders.matchPhraseQuery("posName", this.getPosName()));
        }
        if(StringUtils.isNotBlank(this.getClientArea())){
            builder.must(QueryBuilders.matchPhraseQuery("clientArea", this.getClientArea()));
        }
        if(StringUtils.isNotBlank(this.getClientOffice())){
            builder.must(QueryBuilders.matchPhraseQuery("clientOffice", this.getClientOffice()));
        }
        if(StringUtils.isNotBlank(this.getBrand())){
            builder.must(QueryBuilders.matchPhraseQuery("brand", this.getBrand()));
        }
        if(StringUtils.isNotBlank(this.getSeries())){
            builder.must(QueryBuilders.matchPhraseQuery("series", this.getSeries()));
        }
        if(StringUtils.isNotBlank(this.getStartDate())){
            builder.must(QueryBuilders.rangeQuery("createDate").gte(this.getStartDate()));
        }
        if(StringUtils.isNotBlank(this.getEndDate())){
            builder.must(QueryBuilders.rangeQuery("createDate").lte(this.getEndDate()));
        }
        if(StringUtils.isNotBlank(this.getYearMonth())){
            Date firstDayOfMonth = DateUtil.getFirstDayOfMonth(DateUtil.str2Date(this.getYearMonth(), DateUtil.yyyy_MM));
            Date lastDayOfMonth = DateUtil.getLastDayOfMonth(DateUtil.str2Date(this.getYearMonth(), DateUtil.yyyy_MM));
            String firstFormat = DateUtil.format(firstDayOfMonth, DateUtil.DEFAULT_DAY_PATTERN);
            String lastFormat = DateUtil.format(lastDayOfMonth, DateUtil.DEFAULT_DAY_PATTERN);
            builder.must(QueryBuilders.rangeQuery("createDate").gte(firstFormat));
            builder.must(QueryBuilders.rangeQuery("createDate").lte(lastFormat));
        }


        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("createDate").order(SortOrder.DESC));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("createDateSecond").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
