package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@Data
@ApiModel("查询已完成活动分页-参数")
public class GetCompleteActivityPageReq extends VisitStepPageReq{


    @ApiModelProperty("活动类型")
    private String activityType;

    @ApiModelProperty("客户编码")
    private String clientCode;

    @ApiModelProperty("客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    private String clientType;

    @ApiModelProperty("活动开始时间")
    private String startActivityStartTime;
    @ApiModelProperty("活动开始时间")
    private String endActivityStartTime;


    @ApiModelProperty("活动结束时间")
    private String startActivityEndTime;
    @ApiModelProperty("活动结束时间")
    private String endActivityEndTime;


    @ApiModelProperty("活动执行时间")
    private String startActivityTime;
    @ApiModelProperty("活动执行时间")
    private String endActivityTime;




    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not
        if(StringUtils.isBlank(this.getStepCode())){
            throw new BusinessException("请指定步骤编码");
        }

        builder.must(QueryBuilders.termQuery("stepCode.keyword", this.getStepCode()));
        if(StringUtils.isNotBlank(this.getClientCode())){
            builder.must(QueryBuilders.termQuery("clientCode.keyword", this.getClientCode()));
        }
        if(StringUtils.isNotBlank(this.getStartActivityStartTime())){
            builder.must(QueryBuilders.rangeQuery("activityStartTime").from(this.getStartActivityStartTime()));
        }
        if(StringUtils.isNotBlank(this.getEndActivityStartTime())){
            builder.must(QueryBuilders.rangeQuery("activityStartTime").to(this.getEndActivityStartTime()));
        }

        if(StringUtils.isNotBlank(this.getStartActivityEndTime())){
            builder.must(QueryBuilders.rangeQuery("activityEndTime").from(this.getStartActivityEndTime()));
        }
        if(StringUtils.isNotBlank(this.getEndActivityEndTime())){
            builder.must(QueryBuilders.rangeQuery("activityEndTime").to(this.getEndActivityEndTime()));
        }

        if(StringUtils.isNotBlank(this.getStartActivityTime())){
            builder.must(QueryBuilders.rangeQuery("activityTime").from(this.getStartActivityTime()));
        }
        if(StringUtils.isNotBlank(this.getEndActivityTime())){
            builder.must(QueryBuilders.rangeQuery("activityTime").to(this.getEndActivityTime()));
        }


        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("activityTime").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
