package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

/**
 * @author yangshan
 */
@Data
@ApiModel("活动报表分页-参数")
public class GetCompleteActivityTablePageReq extends VisitStepPageReq{


    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动类型")
    private String activityType;

    @ApiModelProperty("客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称")
    private String clientName;

    @ApiModelProperty("活动执行明细状态")
    private String executeStatus;

    @ApiModelProperty("客户类型名称")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    private String clientSubclassName;

    @ApiModelProperty("活动执行时间")
    private String startActivityTime;
    @ApiModelProperty("活动执行时间")
    private String endActivityTime;

    @ApiModelProperty("活动执行开始时间")
    private String activityStartTimeOne;
    @ApiModelProperty("活动执行开始时间")
    private String activityStartTimeTwo;

    @ApiModelProperty("活动执行结束时间")
    private String activityEndTimeOne;
    @ApiModelProperty("活动执行结束时间")
    private String activityEndTimeTwo;

    @ApiModelProperty("人员账号")
    private String userName;
    @ApiModelProperty("人员名称")
    private String realName;
    @ApiModelProperty("职位编码")
    private String posCode;
    @ApiModelProperty("职位名称")
    private String posName;
    @ApiModelProperty("组织编码")
    private String orgCode;
    @ApiModelProperty("组织名称")
    private String orgName;



    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if(StringUtils.isBlank(this.getStepCode())){
            throw new BusinessException("请指定步骤编码");
        }
        builder.must(QueryBuilders.termQuery("stepCode", this.getStepCode()));

        if(StringUtils.isNotBlank(this.getActivityCode())){
            builder.must(QueryBuilders.termQuery("activityCode.keyword", this.getActivityCode()));
        }
        if(StringUtils.isNotBlank(this.getActivityName())){
            builder.must(QueryBuilders.matchPhraseQuery("activityName", this.getActivityName()));
        }
        if(StringUtils.isNotBlank(this.getClientCode())){
            builder.must(QueryBuilders.termQuery("clientCode.keyword", this.getClientCode()));
        }
        if(StringUtils.isNotBlank(this.getClientName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientName", this.getClientName()));
        }
        if(StringUtils.isNotBlank(this.getExecuteStatus())){
            builder.must(QueryBuilders.termQuery("executeStatus", this.getExecuteStatus()));
        }
        if(StringUtils.isNotBlank(this.getClientTypeName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientTypeName", this.getClientTypeName()));
        }
        if(StringUtils.isNotBlank(this.getClientSubclassName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientSubclassName", this.getClientSubclassName()));
        }

        if(StringUtils.isNotBlank(this.getUserName())){
            builder.must(QueryBuilders.termQuery("userName.keyword", this.getUserName()));
        }
        if(StringUtils.isNotBlank(this.getRealName())){
            builder.must(QueryBuilders.matchPhraseQuery("realName", this.getRealName()));
        }
        if(StringUtils.isNotBlank(this.getOrgCode())){
            builder.must(QueryBuilders.termQuery("orgCode.keyword", this.getOrgCode()));
        }
        if(StringUtils.isNotBlank(this.getOrgName())){
            builder.must(QueryBuilders.matchPhraseQuery("orgName", this.getOrgName()));
        }
        if(StringUtils.isNotBlank(this.getPosCode())){
            builder.must(QueryBuilders.termQuery("posCode.keyword", this.getPosCode()));
        }
        if(StringUtils.isNotBlank(this.getPosName())){
            builder.must(QueryBuilders.matchPhraseQuery("posName", this.getPosName()));
        }

        //活动执行时间
        if(StringUtils.isNotBlank(this.getStartActivityTime())){
            builder.must(QueryBuilders.rangeQuery("activityTime").gte(this.getStartActivityTime()));
        }
        if(StringUtils.isNotBlank(this.getEndActivityTime())){
            builder.must(QueryBuilders.rangeQuery("activityTime").lte(this.getEndActivityTime()));
        }
        //活动执行开始时间
        if(StringUtils.isNotBlank(this.getActivityStartTimeOne())){
            builder.must(QueryBuilders.rangeQuery("activityStartTime").gte(this.getActivityStartTimeOne()));
        }
        if(StringUtils.isNotBlank(this.getActivityStartTimeTwo())){
            builder.must(QueryBuilders.rangeQuery("activityStartTime").lte(this.getActivityStartTimeTwo()));
        }
        //活动执行结束时间
        if(StringUtils.isNotBlank(this.getActivityEndTimeOne())){
            builder.must(QueryBuilders.rangeQuery("activityEndTime").gte(this.getActivityEndTimeOne()));
        }
        if(StringUtils.isNotBlank(this.getActivityEndTimeTwo())){
            builder.must(QueryBuilders.rangeQuery("activityEndTime").lte(this.getActivityEndTimeTwo()));
        }


        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("activityTime").unmappedType("keyword").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
