package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

/**
 * @author yangshan
 */
@Data
@ApiModel("查询库存盘点报表")
public class GetStockInventoryTableReq extends VisitStepPageReq{

    @ApiModelProperty("客户编码")
    private String clientCode;
    @ApiModelProperty("客户类型")
    private String clientType;
    @ApiModelProperty("客户名称")
    private String clientName;
    @ApiModelProperty("人员名称")
    private String realName;
    @ApiModelProperty("产品编码")
    private String productCode;
    @ApiModelProperty("产品名称")
    private String productName;
    @ApiModelProperty("提交时间")
    private String stockTime;
    @ApiModelProperty("人员账号")
    private String userName;
    @ApiModelProperty("开始时间")
    private String startStockTime;
    @ApiModelProperty("结束时间")
    private String endStockTime;


    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not
        if(StringUtils.isBlank(this.getStepCode())){
            throw new BusinessException("请指定步骤编码");
        }
        builder.must(QueryBuilders.termQuery("stepCode.keyword", this.getStepCode()));

        if (StringUtils.isNotEmpty(this.getClientCode())){
            builder.must(QueryBuilders.termQuery("clientCode.keyword", this.getClientCode()));
        }
        if (StringUtils.isNotEmpty(this.getClientName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientName", this.getClientName()));
        }
        if (StringUtils.isNotEmpty(this.getClientType())){
            builder.must(QueryBuilders.termQuery("clientType.keyword", this.getClientType()));
        }
        if (StringUtils.isNotEmpty(this.getRealName())){
            builder.must(QueryBuilders.matchPhraseQuery("realName", this.getRealName()));
        }
        if (StringUtils.isNotEmpty(this.getProductCode())){
            builder.must(QueryBuilders.termQuery("productCode.keyword", this.getProductCode()));
        }
        if (StringUtils.isNotEmpty(this.getProductName())){
            builder.must(QueryBuilders.matchPhraseQuery("productName", this.getProductName()));
        }
        if (StringUtils.isNotEmpty(this.getStockTime())){
            builder.must(QueryBuilders.matchPhraseQuery("stockTime", this.getStockTime()));
        }
        if (StringUtils.isNotEmpty(this.getUserName())){
            builder.must(QueryBuilders.termQuery("userName", this.getUserName()));
        }

        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        if (StringUtils.isNotEmpty(this.getPageNum().toString()) && StringUtils.isNotEmpty(this.getPageSize().toString())){
            nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        }
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("stockTime").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
