package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

/**
 * @author yangshan
 */
@Data
@ApiModel("查询店面检查分页-参数")
public class GetStoreCheckReq extends VisitStepPageReq{


    @ApiModelProperty("客户编码")
    private String clientCode;
    @ApiModelProperty("客户名称")
    private String clientName;
    @ApiModelProperty("人员姓名")
    private String realName;
    @ApiModelProperty("职位名称")
    private String posName;
    @ApiModelProperty("提交时间")
    private String checkTime;
    @ApiModelProperty("客户类型")
    private String clientTypeName;
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not
        if(StringUtils.isBlank(this.getStepCode())){
            throw new BusinessException("请指定步骤编码");
        }

        builder.must(QueryBuilders.termQuery("stepCode.keyword", this.getStepCode()));
        if(StringUtils.isNotBlank(this.getClientCode())){
            builder.must(QueryBuilders.termQuery("clientCode.keyword", this.getClientCode()));
        }
        if(StringUtils.isNotBlank(this.getClientName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientName", this.getClientName()));
        }

        if(StringUtils.isNotBlank(this.getRealName())){
            builder.must(QueryBuilders.matchPhraseQuery("realName", this.getRealName()));
        }

        if(StringUtils.isNotBlank(this.getPosName())){
            builder.must(QueryBuilders.matchPhraseQuery("posName", this.getPosName()));
        }
        if(StringUtils.isNotBlank(this.getOrgName())){
            builder.must(QueryBuilders.matchPhraseQuery("orgName", this.getOrgName()));
        }
        if(StringUtils.isNotBlank(this.getClientTypeName())){
            builder.must(QueryBuilders.matchPhraseQuery("clientTypeName.keyword", this.getClientTypeName()));
        }
        if(StringUtils.isNotBlank(this.getCheckTime())){
            builder.must(QueryBuilders.matchPhraseQuery("checkTime", this.getCheckTime()));
        }

        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("checkTime").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
