package com.biz.crm.visitstep.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityDisplayStepExecuteDataResp;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.data.elasticsearch.annotations.Mapping;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/3/27 10:58
 */
public class SfaVisitStepActivityDetailRespVo {

    @ApiModelProperty("销售额")
    private String salesVolume;

    @ApiModelProperty("申请金额")
    private String applyAmount;

    @ApiModelProperty("活动描述")
    private String activityDesc;

    @ApiModelProperty("上次执行时间")
    private String lastActivityTime;

    @ApiModelProperty("活动执行要求")
    private List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList;

    @ApiModelProperty("陈列要求内容")
    private ActivityDisplayStepExecuteDataResp.DisplayContent displayContent;

    /**
     * 活动执行类型(0-费用活动,1-陈列活动)
     */
    @ApiModelProperty("活动执行类型(0-费用活动,1-陈列活动)")
    private String activityType;
    @ApiModelProperty("活动执行类型(0-费用活动,1-陈列活动)")
    @CrmDict(typeCode = "sfa_activity_type",dictCodeField = "sfa_activity_type")
    private String activityTypeName;


    /**
     * 活动id
     */
    @ApiModelProperty("活动id")
    private String activityExecutionId;

    @ApiModelProperty("拜访计划明细id")
    private String visitPlanInfoId;

    @ApiModelProperty("活动编码")
    private String activityCode;


    /**
     * 网点编码
     */
    @ApiModelProperty("网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @ApiModelProperty("网点名称")
    private String clientName;

    /**
     * 客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)
     */
    @ApiModelProperty("客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    private String clientType;
    @ApiModelProperty("客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "sfacusType")
    private String clientTypeName;

    /**
     * 活动执行时间
     */
    @ApiModelProperty("活动执行时间")
    private String activityTime;

    /**
     * 人员账号
     */
    @ApiModelProperty("人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @ApiModelProperty("人员姓名")
    private String realName;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String posName;

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    private String posCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    private String orgCode;

    /**
     * 活动执行地址
     */
    @ApiModelProperty("活动执行地址")
    private String activityExecutionAddress;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 纬度
     */
    @ApiModelProperty("纬度")
    private String latitude;

    /**
     * 活动名称
     */
    @ApiModelProperty("活动名称")
    private String activityName;

    /**
     * 活动执行开始时间
     */
    @ApiModelProperty("活动执行开始时间")
    private String activityStartTime;

    /**
     * 活动执行结束时间
     */
    @ApiModelProperty("活动执行结束时间")
    private String activityEndTime;

    /**
     * 活动频率
     */
    @ApiModelProperty("活动频率")
    private String activityFrequency;
}
