package com.biz.crm.visitstep.resp;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 *
 * 竞品商品报表
 *
 * @author yangshan
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "竞品商品报表 ")
public class SfaVisitStepColletReportTableRespVo {

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("终端编码")
    private String clientCode;

    @ApiModelProperty("终端名称")
    private String clientName;

    @ApiModelProperty("客户分类")
    private String clientType;

    @ApiModelProperty("客户分类描述")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "clientType")
    private String clientTypeDescribe;

    @ApiModelProperty("创建人姓名")
    private String createName;

    @ApiModelProperty("创建日期")
    private String createDate;

    @ApiModelProperty("创建时间")
    private String createDateSecond;

    @ApiModelProperty("创建人账号")
    private String createCode;

    @ApiModelProperty("创建人职位")
    private String createPosName;

    @ApiModelProperty("终端区域")
    private String clientArea;

    @ApiModelProperty("终端所属办事处")
    private String clientOffice;

    @ApiModelProperty("活动名称")
    private String activityInfo;

    @ApiModelProperty("区域名称")
    private String orgName;

    @ApiModelProperty("组织编号")
    private String createOrgCode;

    @ApiModelProperty("商品详情")
    private List<SfaVisitStepColletItemRespVo> itemRespVos;

    @ApiModelProperty("照片集合")
    private List<CrmAttachment> sfaVisitPictureReqVos;

}
