package com.biz.crm.visitstep.resp;

import com.biz.crm.config.CrmDict;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访步骤控件-查询
 * @author YuanZiJian
 * @date 2021/2/5 13:52
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤控件-查询")
@SaturnEntity(name = "SfaVisitStepFromControlRespVo", description = "拜访步骤控件-查询")
public class SfaVisitStepFromControlRespVo {
    /**
     * 控件名称
     */
    @ApiModelProperty("控件名称")
    private String controlName;
    /**
     * 控件类型（数据字典：SFAcontrolType）
     */
    @ApiModelProperty("控件类型")
    private String controlType;
    /**
     * 控件类型名称（数据字典：SFAcontrolType）
     */
    @ApiModelProperty("控件类型名称")
    @CrmDict(typeCode = "SFAcontrolType",dictCodeField = "controlType")
    private String controlTypeName;
    /**
     * 控件对应的数据字典
     */
    @ApiModelProperty("数据字典")
    private String dictCode;

    /**
     * 扩展参数
     */
    @ApiModelProperty("扩展参数")
    private String extendParam;

    /**
     * 是否必填（Yes/No）
     */
    @ApiModelProperty("是否必填（Yes/No）")
    private String requireType;

    /**
     * 是否必填（Yes/No）名称
     */
    @ApiModelProperty("是否必填（Yes/No）名称")
    @CrmDict(typeCode = "doNot",dictCodeField = "requireType")
    private String requireTypeName;
    /**
     * 排序
     */
    @ApiModelProperty("排序")
    private String sort;

    /**
     * 对应的字段名
     */
    @ApiModelProperty("字段名")
    private String fieldName;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remarks;
}
