package com.biz.crm.visitstep.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用活动执行报表;返回vo
 *
 * @author yangshan
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用活动执行报表;")
@SaturnEntity(name = "SfaVisitStepStoreCostActivityTableRespVo", description = "费用活动执行报表;")
public class SfaVisitStepStoreCostActivityTableRespVo {
    @ApiModelProperty("id")
    @SaturnColumn(description = "id")
    private String id;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String activityName;

    @ApiModelProperty("活动执行明细状态")
    @SaturnColumn(description = "活动执行明细状态")
    private String executeStatus;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    private String clientType;
    @ApiModelProperty("网点类型")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    private String clientSubclass;
    @ApiModelProperty("客户细类")
    private String clientSubclassName;

    @ApiModelProperty("提交时间")
    @SaturnColumn(description = "提交时间")
    private String activityTime;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("活动执行开始时间")
    private String activityStartTime;

    @ApiModelProperty("活动执行结束时间")
    private String activityEndTime;

    @ApiModelProperty("费用预估销售额")
    private String salesVolume;

    @ApiModelProperty("申请金额")
    private String applyAmount;

    @ApiModelProperty("活动id")
    private String activityExecutionId;

    @ApiModelProperty("拜访计划明细id")
    private String visitPlanInfoId;
}