package com.biz.crm.visitstep.service;

import com.biz.crm.visitstep.model.SfaVisitDisplayConfigEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitDisplayConfigRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitDisplayConfigReqVo;

import java.util.List;
import java.util.Map;

/**
 * 拜访(陈列执行配置) 接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
public interface ISfaVisitDisplayConfigService extends IService<SfaVisitDisplayConfigEntity> {

    /**
     * 列表
     * @param sfaVisitDisplayConfigReqVo
     * @return PageResult<SfaVisitDisplayConfigRespVo>
     */
    PageResult<SfaVisitDisplayConfigRespVo> findList(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 有效数据列表
     * @param sfaVisitDisplayConfigReqVo
     * @return PageResult<SfaVisitDisplayConfigRespVo>
     */
    List<SfaVisitDisplayConfigRespVo> getConfig(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 查询
     * @param sfaVisitDisplayConfigReqVo
     * @return SfaVisitDisplayConfigRespVo
     */
    SfaVisitDisplayConfigRespVo query(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 新增
     * @param sfaVisitDisplayConfigReqVo
     * @return
     */
    void save(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 更新
     * @param sfaVisitDisplayConfigReqVo
     * @return
     */
    void update(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 删除
     * @param sfaVisitDisplayConfigReqVo
     * @return
     */
    void deleteBatch(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 启用
     * @param sfaVisitDisplayConfigReqVo
     * @return
     */
    void enableBatch(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 禁用
     * @param sfaVisitDisplayConfigReqVo
     * @return
     */
    void disableBatch(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);
}

