package com.biz.crm.visitstep.service;

import com.biz.crm.visitstep.model.SfaVisitStepActivityEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityReqVo;

import java.util.List;
import java.util.Map;

/**
 * 拜访步骤(活动执行);接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
public interface ISfaVisitStepActivityService extends IService<SfaVisitStepActivityEntity> {

    /**
     * 列表
     * @param sfaVisitStepActivityReqVo
     * @return PageResult<SfaVisitStepActivityRespVo>
     */
    PageResult<SfaVisitStepActivityRespVo> findList(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 根据visitCode查询列表
     * @param visitCode
     * @return PageResult<SfaVisitStepActivityRespVo>
     */
    List<SfaVisitStepActivityRespVo> getListByVisitCode(String visitCode);

    /**
     * 查询
     * @param sfaVisitStepActivityReqVo
     * @return SfaVisitStepActivityRespVo
     */
    SfaVisitStepActivityRespVo query(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 新增
     * @param sfaVisitStepActivityReqVo
     * @return
     */
    void save(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 更新
     * @param sfaVisitStepActivityReqVo
     * @return
     */
    void update(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 删除
     * @param sfaVisitStepActivityReqVo
     * @return
     */
    void deleteBatch(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 启用
     * @param sfaVisitStepActivityReqVo
     * @return
     */
    void enableBatch(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 禁用
     * @param sfaVisitStepActivityReqVo
     * @return
     */
    void disableBatch(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);
}

