package com.biz.crm.visitstep.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitStepProcessReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletItemReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletProductReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReportReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletProductRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletReportRespVo;
import com.biz.crm.visitstep.model.SfaVisitStepColletProductEntity;

import java.util.List;

/**
 * 竞品商品接口
 *
 * @author hej
 * @date 2020-11-23 15:58:45
 */
public interface ISfaVisitStepColletProductService extends IService<SfaVisitStepColletProductEntity> {

    /**
     * 商品竞品列表(web)
     * @param reqVo
     * @return
     */
    PageResult<SfaVisitStepColletProductRespVo> findList(SfaVisitStepColletProductReqVo reqVo);

    /**
     * 商品竞品列表(小程序)
     * @param reqVo
     * @return
     */
    PageResult<SfaVisitStepColletProductRespVo> findListProduct(SfaVisitStepColletProductReqVo reqVo);

    /**
     * 商品竞品报表
     * @param reqVo
     * @return
     */
    PageResult<SfaVisitStepColletReportRespVo> findReportFormsList(SfaVisitStepColletReportReqVo reqVo);

    /**
     * 查详情
     * @param id
     * @return
     */
    SfaVisitStepColletReportRespVo findReportFormsOne(String id);


    /**
     * 查询
     * @param id
     * @return SfaVisitStepActivityRespVo
     */
    SfaVisitStepColletProductRespVo query(String id);

    /**
     * 新增
     * @param sfaVisitStepColletProductReqVo
     * @return
     */
    void save(SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo);


    /**
     * 更新
     * @param sfaVisitStepColletProductReqVo
     * @return
     */
    void update(SfaVisitStepColletProductReqVo sfaVisitStepColletProductReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);


}

