package com.biz.crm.visitstep.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderDetailReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderStockAnalysisReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderDetailProRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderDetailRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderStockAnalysisRespVo;

/**
 * @author ren.gang
 * @ClassName ISfaVisitStepOrderFormService.java
 * @Description web端-订单管理-报表接口
 * @createTime 2021年01月12日 14:30:00
 */
public interface ISfaVisitStepOrderFormService {

    /**
     * 订单明细
     * @param reqVo
     * @return
     */
    PageResult<SfaVisitStepOrderDetailRespVo> orderDetail(SfaVisitStepOrderDetailReqVo reqVo);

    /**
     * 订单明细
     * @param id
     * @return
     */
    SfaVisitStepOrderDetailRespVo orderInfo(String id);

    /**
     * 订单明细(方案活动)
     */
    SfaVisitStepOrderDetailProRespVo orderInfoProgramme(String id);

    /**
     * 终端进货量分析
     * @param reqVo
     * @return
     */
    PageResult<SfaVisitStepOrderStockAnalysisRespVo> stockAnalysis(SfaVisitStepOrderStockAnalysisReqVo reqVo);
}
