package com.biz.crm.visitstep.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.distributionorder.DistributionOrderVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderRedisData;
import com.biz.crm.visitstep.req.GetOrderPageReq;

import java.util.List;

/**
 * 拜访步骤(订单主表);接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
public interface ISfaVisitStepOrderService extends IService<SfaVisitStepOrderEntity> {

    /**
     * 新增
     * @param redisData
     * @return
     */
    SfaVisitStepOrderRedisData save(SfaVisitStepOrderRedisData redisData);


    /**
     * 查询终端供货经销商
     * @param terminalCode
     * @return
     */
    List<MdmTerminalSupplyVo> findTerminalSupplyList(String terminalCode);


    /**
     * 获取订单数
     */
    Integer getOrderNum(String dateFlag);

    /**
     * 工作台保存分销订单
     * @param vo
     */
    String saveWorkBenchDistributionOrder(DistributionOrderVo vo);

    /**
     * tpm活动-分销采集订单-查询详情
     * @param id
     * @return
     */
    DistributionOrderVo loadTpmActDistributionOrderDetail(String id,String actDetailCode);

    /**
     * 拜访步骤-tpm活动-分销订单采集保存
     * @param vo
     */
    String saveVisitStepDistributionOrder(VisitBaseVo<DistributionOrderVo> vo);

    /**
     * web端-查询订单明细报表
     * @param reqVo
     * @return
     */
    PageResult<SfaVisitStepOrderRespVo> orderDetailReport(SfaVisitStepOrderReqVo reqVo);

    /**
     * 工作台-查询订单采集列表
     * @param req
     * @return
     */
    PageResult<SfaVisitStepOrderRespVo> getWorkbenchOrderPage(GetOrderPageReq req);

    /**
     * 根据订单编码查询列表
     * @param orderCodes 订单编码列表
     * @return 返回集合
     */
    List<SfaVisitStepOrderEntity> findByActCodes(List<String> actCodes);

}

