package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitDisplayConfigReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitDisplayConfigRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.mapper.SfaVisitDisplayConfigMapper;
import com.biz.crm.visitstep.model.SfaVisitDisplayConfigEntity;
import com.biz.crm.visitstep.service.ISfaVisitDisplayConfigService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访(陈列执行配置) 接口实现
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaVisitDisplayConfigServiceExpandImpl")
public class SfaVisitDisplayConfigServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitDisplayConfigMapper, SfaVisitDisplayConfigEntity> implements ISfaVisitDisplayConfigService {

    @Resource
    private SfaVisitDisplayConfigMapper sfaVisitDisplayConfigMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitDisplayConfigRespVo> findList(SfaVisitDisplayConfigReqVo reqVo){
        Page<SfaVisitDisplayConfigRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitDisplayConfigRespVo> list = sfaVisitDisplayConfigMapper.findList(page, reqVo);
        return PageResult.<SfaVisitDisplayConfigRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<SfaVisitDisplayConfigRespVo> getConfig(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        //查询启用非删除数据
        QueryWrapper<SfaVisitDisplayConfigEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.ne("del_flag",CrmDelFlagEnum.DELETE.getCode());
        List<SfaVisitDisplayConfigEntity> sfaVisitDisplayConfigEntities = this.list(queryWrapper);
        return CrmBeanUtil.copyList(sfaVisitDisplayConfigEntities,SfaVisitDisplayConfigRespVo.class);
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitDisplayConfigRespVo
     */
    @Override
    public SfaVisitDisplayConfigRespVo query(SfaVisitDisplayConfigReqVo reqVo){
        SfaVisitDisplayConfigEntity sfaVisitDisplayConfigEntity = this.getById(reqVo.getId());
        return CrmBeanUtil.copy(sfaVisitDisplayConfigEntity,SfaVisitDisplayConfigRespVo.class);
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitDisplayConfigReqVo reqVo){
        SfaVisitDisplayConfigEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitDisplayConfigEntity.class);
        //验证
        this.validate(reqVo);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        //保存
        this.save(entity);
    }

    private void validate(SfaVisitDisplayConfigReqVo reqVo){
        //标签名称不能重复
        QueryWrapper<SfaVisitDisplayConfigEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("label_name",reqVo.getLabelName());
        if(StringUtils.isNotEmpty(reqVo.getId())){
            queryWrapper.ne("id",reqVo.getId());
        }
        int row = this.count(queryWrapper);
        if(row>0){
            throw new BusinessException("标签名称不能重复");
        }
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitDisplayConfigReqVo reqVo){
        SfaVisitDisplayConfigEntity entity = this.getById(reqVo.getId());
        //验证
        this.validate(reqVo);
        //修改
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaVisitDisplayConfigReqVo reqVo){
        List<SfaVisitDisplayConfigEntity> sfaVisitDisplayConfigEntities = sfaVisitDisplayConfigMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitDisplayConfigEntities)){
            sfaVisitDisplayConfigEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDisplayConfigEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaVisitDisplayConfigReqVo reqVo){
        //设置状态为启用
        List<SfaVisitDisplayConfigEntity> sfaVisitDisplayConfigEntities = sfaVisitDisplayConfigMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitDisplayConfigEntities)){
            sfaVisitDisplayConfigEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDisplayConfigEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaVisitDisplayConfigReqVo reqVo){
        //设置状态为禁用
        List<SfaVisitDisplayConfigEntity> sfaVisitDisplayConfigEntities = sfaVisitDisplayConfigMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitDisplayConfigEntities)){
                sfaVisitDisplayConfigEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDisplayConfigEntities);
    }
}
