package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityDisplayStepExecuteDataResp;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityExecutionMapper;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityDisplayExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.req.GetCompleteActivityPageReq;
import com.biz.crm.visitstep.req.GetCompleteActivityReq;
import com.biz.crm.visitstep.req.GetCompleteActivityTablePageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreCostActivityTableRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreDisplayActivityTableRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 拜访计划;ES实现
 *  @author: luoqi
 *  @Date: 2021-3-11 14:26
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Service
public class SfaVisitStepActivityExecutionServiceEsImpl {

    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityExecutionMapper sfaVisitStepActivityExecutionMapper;
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private ISfaVisitStepFromService sfaVisitStepFromService;



    /**
     * 查询已完成活动分页
     * @param req
     * @return
     */
    public PageResult<SfaVisitStepActivityExecutionRespVo> getCompleteActivityPage(GetCompleteActivityPageReq req){

        Page<SfaVisitStepActivityExecutionRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());

        GetCompleteActivityTablePageReq reqVo = CrmBeanUtil.copy(req, GetCompleteActivityTablePageReq.class);
        reqVo.setActivityStartTimeOne(req.getStartActivityStartTime());
        reqVo.setActivityStartTimeTwo(req.getEndActivityStartTime());
        reqVo.setActivityEndTimeOne(req.getEndActivityStartTime());
        reqVo.setActivityEndTimeTwo(req.getEndActivityEndTime());
        if(SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(req.getActivityType())){
//            //执行,返回包装结果的分页
//            org.springframework.data.domain.Page<SfaVisitStepActivityDisplayExecutionEsData> list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search(req.buildQuery());
            reqVo.setActivityType(SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal());
            List<SfaVisitStepActivityExecutionRespVo> respVos = this.sfaVisitStepActivityExecutionMapper.findTableList(page, reqVo);
            return PageResult.<SfaVisitStepActivityExecutionRespVo>builder()
                    .data(respVos)
                    .count(page.getTotal())
                    .build();
        }else{
//            //执行,返回包装结果的分页
//            org.springframework.data.domain.Page<SfaVisitStepActivityCostExecutionEsData> list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search(req.buildQuery());
            reqVo.setActivityType(SfaVisitEnum.visitStep.VISIT_STEP_COST.getVal());
            List<SfaVisitStepActivityExecutionRespVo> respVos = this.sfaVisitStepActivityExecutionMapper.findTableList(page, reqVo);
            return PageResult.<SfaVisitStepActivityExecutionRespVo>builder()
                    .data(respVos)
                    .count(page.getTotal())
                    .build();
        }

    }

    /**
     * 查询已完成费用活动列表
     * @param req
     * @return
     */
    public List<SfaVisitStepActivityCostExecutionEsData> getCompleteCostActivityList(GetCompleteActivityReq req){

        //执行,返回包装结果的分页
        Iterable<SfaVisitStepActivityCostExecutionEsData> list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search(req.buildQuery());
        return Lists.newArrayList(list);

    }

    /**
     * 查询给定日期之前(包含该日期)的执行完成费用活动id
     * @param stepCode
     * @param clientCode
     * @param date
     * @return
     */
    public Set<String> getCompleteCostActivityIdsBeforeDate(String stepCode, String clientCode, LocalDate date){
        //费用活动
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setEndActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + CrmDateUtils.TIME_STR_235959);
        return this.getCompleteCostActivityList(req)
                .stream().map(SfaVisitStepActivityCostExecutionEsData :: getActivityExecutionId).collect(Collectors.toSet());
    }
    /**
     * 查询给定日期之后(包含该日期)的执行完成费用活动id
     * @param stepCode
     * @param clientCode
     * @param date
     * @return
     */
    public Set<String> getCompleteCostActivityIdsAfterDate(String stepCode, String clientCode, LocalDate date){
        //费用活动
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setStartActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + CrmDateUtils.TIME_STR_00);
        return this.getCompleteCostActivityList(req)
                .stream().map(SfaVisitStepActivityCostExecutionEsData :: getActivityExecutionId).collect(Collectors.toSet());
    }

    /**
     * 查询已完成陈列活动列表
     * @param req
     * @return
     */
    public List<SfaVisitStepActivityDisplayExecutionEsData> getCompleteDisplayActivityList(GetCompleteActivityReq req){

        //执行,返回包装结果的分页
        Iterable<SfaVisitStepActivityDisplayExecutionEsData> list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search(req.buildQuery());
        return Lists.newArrayList(list);

    }

    /**
     * 查询给定日期之前(包含该日期)的执行完成陈列活动id
     * @param stepCode
     * @param clientCode
     * @param date
     * @return
     */
    public Set<String> getCompleteDisplayActivityIdsBeforeDate(String stepCode, String clientCode, LocalDate date){
        //费用活动
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setEndActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + CrmDateUtils.TIME_STR_235959);
        return this.getCompleteDisplayActivityList(req)
                .stream().map(SfaVisitStepActivityDisplayExecutionEsData :: getActivityExecutionId).collect(Collectors.toSet());
    }

    /**
     * 获取给定时间最近一次执行记录
     * @param stepCode
     * @param clientCode
     * @param activityTime
     * @return
     */
    public SfaVisitStepActivityDisplayExecutionEsData getLastActivityTimeRecord(String stepCode, String clientCode, LocalDateTime activityTime, String currentId){
        if(StringUtils.isBlank(stepCode)){
            throw new BusinessException("请指定步骤编码");
        }

        if(StringUtils.isBlank(clientCode)){
            throw new BusinessException("请指定客户编码");
        }
        if(null == activityTime){
            throw new BusinessException("请指定执行时间");
        }

        List<SfaVisitStepActivityExecutionEntity> entities = this.sfaVisitStepActivityExecutionMapper.selectList(Wrappers.lambdaQuery(SfaVisitStepActivityExecutionEntity.class)
                .le(SfaVisitStepActivityExecutionEntity::getActivityTime, activityTime)
                .eq(SfaVisitStepActivityExecutionEntity::getClientCode, clientCode)
                .eq(SfaVisitStepActivityExecutionEntity::getStepCode, stepCode)
                .orderByDesc(SfaVisitStepActivityExecutionEntity::getActivityTime));

        List<SfaVisitStepActivityDisplayExecutionEsData> list = CrmBeanUtil.copyList(entities, SfaVisitStepActivityDisplayExecutionEsData.class);

//        BoolQueryBuilder builder = QueryBuilders.boolQuery();
//
//        builder.must(QueryBuilders.termQuery("stepCode.keyword", stepCode));
//        builder.must(QueryBuilders.termQuery("clientCode.keyword", clientCode));
//
//        builder.must(QueryBuilders.rangeQuery("activityTime").lte(activityTime.format(CrmDateUtils.yyyyMMddHHmmss)));
////        builder.must(QueryBuilders.spanNotQuery(QueryBuilders.spanTermQuery("id.keyword", currentId), QueryBuilders.spanTermQuery("id.keyword", currentId)));
//
//        //构建查询
//        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
//        //将搜索条件设置到构建中
//        nativeSearchQueryBuilder.withQuery(builder);
//        //设置分页
//        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
//        nativeSearchQueryBuilder.withPageable(PageRequest.of(0, 2));
//        //排序
//        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("activityTime").order(SortOrder.DESC));
//        //生产NativeSearchQuery
//        NativeSearchQuery query = nativeSearchQueryBuilder.build();
//        List<SfaVisitStepActivityDisplayExecutionEsData> list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search(query).getContent();
        if(list.size() > 0){
            SfaVisitStepActivityDisplayExecutionEsData dataCurrent = list.get(0);
            SfaVisitStepActivityDisplayExecutionEsData data = list.size() > 1 ? list.get(1) : null;
            if(dataCurrent.getId().equals(currentId)){
                return data;
            }
            return dataCurrent;
        }
        return null;
    }
    /**
     * 查询给定日期之后(包含该日期)的执行完成陈列活动id
     * @param stepCode
     * @param clientCode
     * @param date
     * @return
     */
    public Set<String> getCompleteDisplayActivityIdsAfterDate(String stepCode, String clientCode, LocalDate date){
        //费用活动
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setStartActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + CrmDateUtils.TIME_STR_00);
        return this.getCompleteDisplayActivityList(req)
                .stream().map(SfaVisitStepActivityDisplayExecutionEsData :: getActivityExecutionId).collect(Collectors.toSet());
    }

    /**
     * 费用活动执行报表
     */
    @EsDataPermission(userName = "userName.keyword", position = "posCode.keyword", org = "orgCode.keyword", customer = "clientCode.keyword")
    public PageResult<SfaVisitStepStoreCostActivityTableRespVo> findVisitStepCostActivityExecutionEsList(GetCompleteActivityTablePageReq req){
//        org.springframework.data.domain.Page<SfaVisitStepActivityCostExecutionEsData> costList = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search(req.buildQuery());
//        List<SfaVisitStepStoreCostActivityTableRespVo> result = CrmBeanUtil.copyList(costList.getContent(), SfaVisitStepStoreCostActivityTableRespVo.class);

        Page<SfaVisitStepActivityExecutionRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        req.setActivityType(SfaVisitEnum.visitStep.cost);
        List<SfaVisitStepActivityExecutionRespVo> list = this.sfaVisitStepActivityExecutionMapper.findTableList(page, req);
        return PageResult.<SfaVisitStepStoreCostActivityTableRespVo>builder()
                .data(CrmBeanUtil.copyList(list, SfaVisitStepStoreCostActivityTableRespVo.class))
                .count(page.getTotal())
                .build();
    }

    /**
     * 费用活动执行报表详情
     */
    public SfaVisitStepActivityCostExecutionEsData findVisitStepCostActivityExecutionDetailEs(String id){
//        BoolQueryBuilder builder = QueryBuilders.boolQuery();
//        builder.must(QueryBuilders.termQuery("id", id));
//        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
//        nativeSearchQueryBuilder.withQuery(builder);
//        NativeSearchQuery query = nativeSearchQueryBuilder.build();
//        Iterable<SfaVisitStepActivityCostExecutionEsData> list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search(query);
//        ArrayList<SfaVisitStepActivityCostExecutionEsData> result = Lists.newArrayList(list);
//        if (CollectionUtil.listEmpty(result)){
//            return new SfaVisitStepActivityCostExecutionEsData();
//        }
//        return result.get(0);
        SfaVisitStepActivityExecutionEntity entity = this.sfaVisitStepActivityExecutionMapper.selectById(id);
        SfaVisitStepActivityDisplayExecutionEsData result = CrmBeanUtil.copy(entity, SfaVisitStepActivityDisplayExecutionEsData.class);

        if(ObjectUtils.isEmpty(result)){
            throw new BusinessException("未查询到活动执行数据！");
        }
        this.buildData(result);
        SfaVisitStepActivityDisplayExecutionEsData detail = this.findVisitStepDisplayActivityExecutionDetailEs(id);
        return CrmBeanUtil.copy(detail, SfaVisitStepActivityCostExecutionEsData.class);
    }
    /**
     * 陈列活动执行报表
     */
    @EsDataPermission(userName = "userName.keyword", position = "posCode.keyword", org = "orgCode.keyword", customer = "clientCode.keyword")
    public PageResult<SfaVisitStepStoreDisplayActivityTableRespVo> findVisitStepDisplayActivityExecutionEsList(GetCompleteActivityTablePageReq req){
//        org.springframework.data.domain.Page<SfaVisitStepActivityDisplayExecutionEsData> displayList = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search(req.buildQuery());
//        List<SfaVisitStepStoreDisplayActivityTableRespVo> result = CrmBeanUtil.copyList(displayList.getContent(), SfaVisitStepStoreDisplayActivityTableRespVo.class);
        Page<SfaVisitStepActivityExecutionRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        req.setActivityType(SfaVisitEnum.visitStep.display);
        List<SfaVisitStepActivityExecutionRespVo> list = this.sfaVisitStepActivityExecutionMapper.findTableList(page, req);
        return PageResult.<SfaVisitStepStoreDisplayActivityTableRespVo>builder()
                .data(CrmBeanUtil.copyList(list, SfaVisitStepStoreDisplayActivityTableRespVo.class))
                .count(page.getTotal())
                .build();
    }

    /**
     * 陈列活动执行报表详情
     */
    public SfaVisitStepActivityDisplayExecutionEsData findVisitStepDisplayActivityExecutionDetailEs(String id){
//        BoolQueryBuilder builder = QueryBuilders.boolQuery();
//        builder.must(QueryBuilders.termQuery("id", id));
//        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
//        nativeSearchQueryBuilder.withQuery(builder);
//        NativeSearchQuery query = nativeSearchQueryBuilder.build();
//        Iterable<SfaVisitStepActivityDisplayExecutionEsData> list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search(query);
//        ArrayList<SfaVisitStepActivityDisplayExecutionEsData> result = Lists.newArrayList(list);
//        if (CollectionUtil.listEmpty(result)){
//            return new SfaVisitStepActivityDisplayExecutionEsData();
//        }
//        return result.get(0);
        SfaVisitStepActivityExecutionEntity entity = this.sfaVisitStepActivityExecutionMapper.selectById(id);
        SfaVisitStepActivityDisplayExecutionEsData result = CrmBeanUtil.copy(entity, SfaVisitStepActivityDisplayExecutionEsData.class);

        if(ObjectUtils.isEmpty(result)){
            throw new BusinessException("未查询到活动执行数据！");
        }
        this.buildData(result);
//            this.buildForm(result, result.getFormId());
        return result;
    }

    /**
     * 活动执行要求
     * @param requireList
     * @param result
     * @return
     */
    protected void buildRequire(List<String> requireList, SfaVisitStepActivityDisplayExecutionEsData result){
        ArrayList<ActivityStepExecuteData.ActivityRequireReqVo> require = Lists.newArrayList();
        requireList.forEach(v -> {
            if (SfaActivityEnum.activityRequire.ACTIVITY_PIC.getVal().equals(v)){
                ActivityStepExecuteData.ActivityRequireReqVo vo = new ActivityStepExecuteData.ActivityRequireReqVo();
                List<SfaAttachmentEntity> pics0 = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.ACTIVITY_REQUIRE0.getVal(), result.getId());
                vo.setActivityRequire(SfaActivityEnum.activityRequire.ACTIVITY_PIC.getVal());
                vo.setActivityRequireName(SfaActivityEnum.activityRequire.ACTIVITY_PIC.getDesc());
                vo.setPictureList(CrmBeanUtil.copyList(pics0, CrmAttachment.class));
                require.add(vo);
            }
            if (SfaActivityEnum.activityRequire.DOOR_PIC.getVal().equals(v)){
                ActivityStepExecuteData.ActivityRequireReqVo vo = new ActivityStepExecuteData.ActivityRequireReqVo();
                List<SfaAttachmentEntity> pics1 = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.ACTIVITY_REQUIRE1.getVal(), result.getId());
                vo.setActivityRequire(SfaActivityEnum.activityRequire.DOOR_PIC.getVal());
                vo.setActivityRequireName(SfaActivityEnum.activityRequire.DOOR_PIC.getDesc());
                vo.setPictureList(CrmBeanUtil.copyList(pics1, CrmAttachment.class));
                require.add(vo);
            }
            if (SfaActivityEnum.activityRequire.DISPLAY_PIC.getVal().equals(v)){
                ActivityStepExecuteData.ActivityRequireReqVo vo = new ActivityStepExecuteData.ActivityRequireReqVo();
                List<SfaAttachmentEntity> pics2 = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.ACTIVITY_REQUIRE2.getVal(), result.getId());
                vo.setActivityRequire(SfaActivityEnum.activityRequire.DISPLAY_PIC.getVal());
                vo.setActivityRequireName(SfaActivityEnum.activityRequire.DISPLAY_PIC.getDesc());
                vo.setPictureList(CrmBeanUtil.copyList(pics2, CrmAttachment.class));
                require.add(vo);
            }
        });
        result.setActivityRequireReqVoList(require);
    }

    /**
     *
     */
    protected void buildData(SfaVisitStepActivityDisplayExecutionEsData result){
        ActivityDisplayStepExecuteDataResp.DisplayContent displayContent = new ActivityDisplayStepExecuteDataResp.DisplayContent();
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = sfaActivityExecutionService.queryDetailById(result.getActivityExecutionId());
        displayContent.setActivityProductList(sfaActivityExecutionRespVo.getActivityProductList());
        List<SfaVisitPictureRespVo> visitPictureList = sfaActivityExecutionRespVo.getVisitPictureList();
        List<CrmAttachment> pictureList = CrmAttachment.convertVisitPic(visitPictureList);
        displayContent.setPictureList(pictureList);
        result.setDisplayContent(displayContent);
        result.setActivityDesc(sfaActivityExecutionRespVo.getActivityDesc());

        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(sfaActivityExecutionRespVo.getActivityType())){
            result.setSalesVolume(sfaActivityExecutionRespVo.getSalesVolume());
            result.setApplyAmount(sfaActivityExecutionRespVo.getApplyAmount());
        }

        String[] activityRequire = sfaActivityExecutionRespVo.getActivityRequire().split(",");
        ArrayList<String> requireList = Lists.newArrayList();
        Collections.addAll(requireList, activityRequire);
        this.buildRequire(requireList, result);
    }

    protected void buildForm(SfaVisitStepActivityDisplayExecutionEsData result, String formId){
        SfaVisitStepFromRespVo fromRespVo = this.sfaVisitStepFromService.queryById(formId);
        result.setSfaVisitStepFrom(fromRespVo);
    }
}
