package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionTypeReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionTypeRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityExecutionTypeMapper;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionTypeEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionTypeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访步骤(活动执行要求);接口实现
 *
 * @author lf
 * @date 2020-12-30 19:45:13
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaVisitStepActivityExecutionTypeServiceExpandImpl")
public class SfaVisitStepActivityExecutionTypeServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaVisitStepActivityExecutionTypeMapper, SfaVisitStepActivityExecutionTypeEntity> implements ISfaVisitStepActivityExecutionTypeService {

    @Resource
    private SfaVisitStepActivityExecutionTypeMapper sfaVisitStepActivityExecutionTypeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitStepActivityExecutionTypeRespVo> findList(SfaVisitStepActivityExecutionTypeReqVo reqVo){
        Page<SfaVisitStepActivityExecutionTypeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepActivityExecutionTypeRespVo> list = sfaVisitStepActivityExecutionTypeMapper.findList(page, reqVo);
        return PageResult.<SfaVisitStepActivityExecutionTypeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitStepActivityExecutionTypeRespVo
     */
    @Override
    public SfaVisitStepActivityExecutionTypeRespVo query(SfaVisitStepActivityExecutionTypeReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitStepActivityExecutionTypeReqVo reqVo){
        SfaVisitStepActivityExecutionTypeEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitStepActivityExecutionTypeEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitStepActivityExecutionTypeReqVo reqVo){
        SfaVisitStepActivityExecutionTypeEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaVisitStepActivityExecutionTypeReqVo reqVo){
        List<SfaVisitStepActivityExecutionTypeEntity> sfaVisitStepActivityExecutionTypeEntities = sfaVisitStepActivityExecutionTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepActivityExecutionTypeEntities)){
            sfaVisitStepActivityExecutionTypeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityExecutionTypeEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaVisitStepActivityExecutionTypeReqVo reqVo){
        //设置状态为启用
        List<SfaVisitStepActivityExecutionTypeEntity> sfaVisitStepActivityExecutionTypeEntities = sfaVisitStepActivityExecutionTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepActivityExecutionTypeEntities)){
            sfaVisitStepActivityExecutionTypeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityExecutionTypeEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaVisitStepActivityExecutionTypeReqVo reqVo){
        //设置状态为禁用
        List<SfaVisitStepActivityExecutionTypeEntity> sfaVisitStepActivityExecutionTypeEntities = sfaVisitStepActivityExecutionTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepActivityExecutionTypeEntities)){
                sfaVisitStepActivityExecutionTypeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepActivityExecutionTypeEntities);
    }
}
