package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletReportRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletMapper;
import com.biz.crm.visitstep.model.SfaVisitStepColletEsData;
import com.biz.crm.visitstep.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.req.GetColletPageReq;
import com.biz.crm.visitstep.req.GetColletTablePageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepColletReportTableRespVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;


/**
 * 竞品采集;ES实现
 *  @author: luoqi
 *  @Date: 2021-3-11 14:26
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Service
public class SfaVisitStepColletServiceEsImpl {

    @Resource
    private SfaVisitStepColletEsDataRepositories sfaVisitStepColletEsDataRepositories;
    @Resource
    private SfaVisitStepColletMapper sfaVisitStepColletMapper;



    /**
     * 查询竞品采集分页
     * @param req
     * @return
     */
    public PageResult<SfaVisitStepColletReportRespVo> getWorkbenchCompetitorPage(GetColletPageReq req){

        //执行,返回包装结果的分页
        org.springframework.data.domain.Page<SfaVisitStepColletEsData> list = this.sfaVisitStepColletEsDataRepositories.search(req.buildQuery());
        List<SfaVisitStepColletEsData> getContent = list.getContent();
        List<SfaVisitStepColletReportRespVo> reportRespVos = Lists.newArrayList();

        for (SfaVisitStepColletEsData sfaVisitStepColletEsData : getContent) {
            SfaVisitStepColletReportRespVo reportRespVo = CrmBeanUtil.copy(sfaVisitStepColletEsData, SfaVisitStepColletReportRespVo.class);
            List<CompetitorStepExecuteData.ColletItemReqVo> itemReqVos = sfaVisitStepColletEsData.getSfaVisitStepColletItemReqVos();
            StringJoiner brandNames = new StringJoiner(",");
            for (CompetitorStepExecuteData.ColletItemReqVo itemReqVo : itemReqVos) {
                brandNames.add(itemReqVo.getBrand());
            }
            reportRespVo.setBrandName(brandNames.toString());
            reportRespVos.add(reportRespVo);
        }

        return PageResult.<SfaVisitStepColletReportRespVo>builder()
                .data(reportRespVos)
                .count(list.getTotalElements())
                .build();

    }

    /**
     *  竞品采集报表
     * @param req
     * @return
     */
    public PageResult<SfaVisitStepColletReportTableRespVo> findReportFormsEsList(GetColletTablePageReq req) {
//        org.springframework.data.domain.Page<SfaVisitStepColletEsData> data = this.sfaVisitStepColletEsDataRepositories.search(req.buildQuery());
//        List<SfaVisitStepColletReportTableRespVo> sfaVisitStepColletReportRespVos = Lists.newArrayList();
//        data.getContent().forEach(o -> {
//            SfaVisitStepColletReportTableRespVo result = CrmBeanUtil.copy(o, SfaVisitStepColletReportTableRespVo.class);
//            result.setItemRespVos(CrmBeanUtil.copyList(o.getSfaVisitStepColletItemReqVos(), SfaVisitStepColletItemRespVo.class));
//            sfaVisitStepColletReportRespVos.add(result);
//        });

//        return PageResult.<SfaVisitStepColletReportTableRespVo>builder()
//                .data(CrmBeanUtil.copyList(data.getContent(), SfaVisitStepColletReportTableRespVo.class))
//                .count(data.getTotalElements())
//                .build();
        Page<SfaVisitStepColletReportTableRespVo> page = new Page<>(req.getPageNum(),req.getPageSize());
        List<SfaVisitStepColletReportTableRespVo> list = sfaVisitStepColletMapper.findCollectReportList(page,req);
        return PageResult.<SfaVisitStepColletReportTableRespVo>builder()
                .count(page.getTotal())
                .data(list)
                .build();
    }

    /**
     *  竞品采集报表详情
     * @param
     * @return
     */
    public SfaVisitStepColletReportTableRespVo findReportFormsEsDetail(String id) {

        Optional<SfaVisitStepColletEsData> resp = this.sfaVisitStepColletEsDataRepositories.findById(id);
        if (ObjectUtils.isEmpty(resp)){
            return new SfaVisitStepColletReportTableRespVo();
        }
        SfaVisitStepColletReportTableRespVo result = CrmBeanUtil.copy(resp.get(), SfaVisitStepColletReportTableRespVo.class);
        result.setItemRespVos(CrmBeanUtil.copyList(resp.get().getSfaVisitStepColletItemReqVos(), SfaVisitStepColletItemRespVo.class));
        return result;
    }


}
