package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.sfa.VisitStepFromEnum;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.sfa.visitstep.req.*;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromListRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromToStepRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepIconRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.visitstep.mapper.SfaVisitStepFromMapper;
import com.biz.crm.visitstep.model.SfaVisitStepFromControlEntity;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.model.SfaVisitStepFromModelEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromControlRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepFromModelRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepFromControlService;
import com.biz.crm.visitstep.service.ISfaVisitStepFromModelService;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访步骤表单_实现类
 *
 * @author YuanZiJian
 * @date 2021/2/4 11:01
 * @version: V1.0
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitStepFromServiceExpandImpl")
public class SfaVisitStepFromServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepFromMapper, SfaVisitStepFromEntity> implements ISfaVisitStepFromService {
    private int sort = 0;

    @Resource
    ISfaVisitStepFromModelService iSfaVisitStepFromModelService;

    @Resource
    ISfaVisitStepFromControlService iSfaVisitStepFromControlService;
    @Resource
    protected RedisService redisService;

    /**
     * 根据名字查询出相关下拉拜访步骤表单数据
     *
     * @param sfaVisitStepFromToStepSearchReqVo 查询条件Vo
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromToStepRespVo>
     * @method queryListToStep
     * @date: 2021/2/22 15:15
     * @author: YuanZiJian
     */
    @Override
    public PageResult<SfaVisitStepFromToStepRespVo> queryListToStep(SfaVisitStepFromToStepSearchReqVo sfaVisitStepFromToStepSearchReqVo) {
        //基本校验
        AssertUtils.isNotEmpty(sfaVisitStepFromToStepSearchReqVo.getVisitType(), "请选择拜访类型");
        if (!SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(sfaVisitStepFromToStepSearchReqVo.getVisitType())) {
            AssertUtils.isNotEmpty(sfaVisitStepFromToStepSearchReqVo.getCustomerType(), "请选择客户类型");
            String configRange = ParamUtil.getParameterValue(ParameterParam.SFA_VISIT_STEP_CONFIG_CLIENT_SUBCLASS_RANGE);
            if (!YesNoEnum.yesNoEnum.NO.getValue().equals(configRange)) {
                AssertUtils.isNotEmpty(sfaVisitStepFromToStepSearchReqVo.getClientSubclass(), "请选择客户细类");
            } else {
                sfaVisitStepFromToStepSearchReqVo.setClientSubclass(null);
            }
        } else {
            sfaVisitStepFromToStepSearchReqVo.setCustomerType(null);
            sfaVisitStepFromToStepSearchReqVo.setClientSubclass(null);
        }

        //封装查询条件
        LambdaQueryWrapper<SfaVisitStepFromEntity> queryWrapper = Wrappers.lambdaQuery(SfaVisitStepFromEntity.class);
        queryWrapper.eq(SfaVisitStepFromEntity::getVisitType, sfaVisitStepFromToStepSearchReqVo.getVisitType());
        queryWrapper.eq(SfaVisitStepFromEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .eq(SfaVisitStepFromEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode());

        if (StringUtils.isNotEmpty(sfaVisitStepFromToStepSearchReqVo.getCustomerType())) {
            queryWrapper.eq(SfaVisitStepFromEntity::getCustomerType, sfaVisitStepFromToStepSearchReqVo.getCustomerType());
        }
        if (StringUtils.isNotEmpty(sfaVisitStepFromToStepSearchReqVo.getClientSubclass())) {
            queryWrapper.eq(SfaVisitStepFromEntity::getClientSubclass, sfaVisitStepFromToStepSearchReqVo.getClientSubclass());
        }

        if (StringUtils.isNotEmpty(sfaVisitStepFromToStepSearchReqVo.getPageCode())) {
            queryWrapper.eq(SfaVisitStepFromEntity::getPageCode, sfaVisitStepFromToStepSearchReqVo.getPageCode());
        }
        if (StringUtils.isNotEmpty(sfaVisitStepFromToStepSearchReqVo.getStepCode())) {
            queryWrapper.eq(SfaVisitStepFromEntity::getStepCode, sfaVisitStepFromToStepSearchReqVo.getStepCode());
        }
        if (StringUtils.isNotEmpty(sfaVisitStepFromToStepSearchReqVo.getFromName())) {
            queryWrapper.like(SfaVisitStepFromEntity::getFromName, sfaVisitStepFromToStepSearchReqVo.getFromName());
        }
        queryWrapper.orderByDesc(SfaVisitStepFromEntity::getVisitType);

        Page<SfaVisitStepFromEntity> page = new Page<>(sfaVisitStepFromToStepSearchReqVo.getPageNum(), sfaVisitStepFromToStepSearchReqVo.getPageSize());
        //分页查询
        Page<SfaVisitStepFromEntity> fromEntityPage = this.page(page, queryWrapper);
        List<SfaVisitStepFromToStepRespVo> sfaVisitStepFromToStepRespVos = CrmBeanUtil.copyList(fromEntityPage.getRecords(), SfaVisitStepFromToStepRespVo.class);
        return PageResult.<SfaVisitStepFromToStepRespVo>builder()
                .count(fromEntityPage.getTotal())
                .data(sfaVisitStepFromToStepRespVos)
                .build();
    }

    /**
     * 根据主键Id查询拜访步骤表单详情
     *
     * @param id 拜访步骤保单主键ID
     * @return com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo
     * @method queryById
     * @date: 2021/2/5 15:16
     * @author: YuanZiJian
     */
    @Override
    public SfaVisitStepFromRespVo queryById(String id) {
        if (StringUtils.isEmpty(id)) {
            throw new BusinessException("请指定表单ID");
        }
        SfaVisitStepFromRespVo fromRespVo = (SfaVisitStepFromRespVo) this.redisService.hmget(SfaVisitStepFromRespVo.redisHash().toString(), id);
        if (null != fromRespVo) {
            return fromRespVo;
        }
        SfaVisitStepFromEntity fromEntity = this.getById(id);
        if (null == fromEntity) {
            return null;
        }
        fromRespVo = CrmBeanUtil.copy(fromEntity, SfaVisitStepFromRespVo.class);
        //获取相应的模块信息
        List<SfaVisitStepFromModelEntity> modelList = iSfaVisitStepFromModelService.list(
                Wrappers.lambdaQuery(SfaVisitStepFromModelEntity.class)
                        .eq(SfaVisitStepFromModelEntity::getFromId, fromRespVo.getId())
                        .orderByAsc(SfaVisitStepFromModelEntity::getModelSort));
        List<SfaVisitStepFromModelRespVo> modelRespVos = new ArrayList<>();
        modelList.forEach(data -> {
            //获取相应的控件信息
            List<SfaVisitStepFromControlEntity> list = iSfaVisitStepFromControlService.list(
                    Wrappers.lambdaQuery(SfaVisitStepFromControlEntity.class)
                            .eq(SfaVisitStepFromControlEntity::getModelId, data.getId())
                            .orderByAsc(SfaVisitStepFromControlEntity::getSort));
            SfaVisitStepFromModelRespVo fromModelRespVo = CrmBeanUtil.copy(data, SfaVisitStepFromModelRespVo.class);
            fromModelRespVo.setModelIcon(JsonPropertyUtil.toArray(data.getModelIcon(), SfaVisitStepIconRespVo.class));
            fromModelRespVo.setSfaVisitStepFromControlRespVoList(CrmBeanUtil.copyList(list, SfaVisitStepFromControlRespVo.class));
            fromModelRespVo.getSfaVisitStepFromControlRespVoList().forEach(item -> {
                item.setControlTypeName(DictUtil.dictValue("SFAcontrolType", item.getControlType()));
                item.setRequireTypeName(DictUtil.dictValue("doNot", item.getRequireType()));
            });
            modelRespVos.add(fromModelRespVo);
        });
        fromRespVo.setStepFromModelRespVoList(modelRespVos);
        //保存到redis
        this.redisService.hmset(SfaVisitStepFromRespVo.redisHash().toString()
                , fromRespVo.buildRedisDataForWrite(), SfaVisitStepFromEntity.CACHE_TIME);
        return fromRespVo;
    }


    /**
     * 拜访步骤表单—— 分页查询步骤表单列表
     *
     * @param sfaVisitStepFromSearchReqVo 步骤表单查询Vo
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromListRespVo>
     * @method queryList
     * @date: 2021/2/5 10:55
     * @author: YuanZiJian
     */
    @Override
    public PageResult<SfaVisitStepFromListRespVo> queryList(SfaVisitStepFromSearchReqVo sfaVisitStepFromSearchReqVo) {
        Page<SfaVisitStepFromEntity> page = new Page(sfaVisitStepFromSearchReqVo.getPageNum(), sfaVisitStepFromSearchReqVo.getPageSize());
        //封装模糊条件
        LambdaQueryWrapper<SfaVisitStepFromEntity> wrapper = getWrapper(sfaVisitStepFromSearchReqVo);

        Page<SfaVisitStepFromEntity> entityPage = this.page(page, wrapper);
        //entity转换Vo
        List<SfaVisitStepFromListRespVo> sfaVisitStepFromListRespVos = CrmBeanUtil.copyList(entityPage.getRecords(), SfaVisitStepFromListRespVo.class);
        return PageResult.<SfaVisitStepFromListRespVo>builder()
                .data(sfaVisitStepFromListRespVos)
                .count(page.getTotal())
                .build();
    }

    /**
     * 拜访步骤表单—— 新增和编辑
     *
     * @param sfaVisitStepFromReqVo 接收步骤表单新增修改信息Vo
     * @return void
     * @method saveOrUpdate
     * @date: 2021/2/5 12:37
     * @author: YuanZiJian
     */
    @Override
    @Transactional
    public void saveOrUpdate(SfaVisitStepFromReqVo sfaVisitStepFromReqVo) {
        //基础校验
        checkVo(sfaVisitStepFromReqVo);
        //不存在ID就新增
        if (StringUtils.isEmpty(sfaVisitStepFromReqVo.getId())) {
            saveFrom(sfaVisitStepFromReqVo);
        }
        //存在ID就编辑
        else {
            updateFrom(sfaVisitStepFromReqVo);
        }
    }

    /**
     * 查询、新增全局表单
     *
     * @param pageCode
     * @param stepCode
     */
    @Override
    @Transactional
    public SfaVisitStepFromRespVo loadOrAddGlobalForm(String pageCode, String stepCode) {

        if (org.apache.commons.lang3.StringUtils.isBlank(pageCode)) {
            throw new BusinessException("新增全局步骤表单失败，模板编码为空!");
        }
        SfaVisitStepFromRespVo fromRespVo = this.queryById(stepCode);
        if (null != fromRespVo) {
            return fromRespVo;
        }
        if (log.isWarnEnabled()) {
            log.warn("未加载到[" + stepCode + "]步骤配置，尝试自动生成该步骤的全局表单");
        }
        return this.addGlobalForm(pageCode, stepCode);
    }

    protected SfaVisitStepFromRespVo addGlobalForm(String pageCode, String stepCode) {
        if (org.apache.commons.lang3.StringUtils.isBlank(stepCode)) {
            throw new BusinessException("新增全局步骤表单失败，步骤编码为空!");
        }

        SfaVisitStepFromReqVo sfaVisitStepFromReqVo = new SfaVisitStepFromReqVo();
        sfaVisitStepFromReqVo.setPageCode(pageCode);
        sfaVisitStepFromReqVo.setStepCode(stepCode);
        String fromName = null;
        Map<String, String> dictMap = DictUtil.getDictValueMapsByCodes(SfaCodeEnum.VisitStepCode.DICT_CODE);
        if (null != dictMap) {
            fromName = dictMap.get(stepCode);
        }
        sfaVisitStepFromReqVo.setFromName(fromName);
        sfaVisitStepFromReqVo.setId(stepCode);
        sfaVisitStepFromReqVo.setLocateType(YesNoEnum.yesNoEnum.NO.getValue());
        sfaVisitStepFromReqVo.setTimeType(VisitStepFromEnum.timeType.LONG_TIME.getValue());
        sfaVisitStepFromReqVo.setRemarks("默认全局表单，禁止进行修改、删除、禁用");
        sfaVisitStepFromReqVo.setVisitType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        return this.saveFrom(sfaVisitStepFromReqVo);
    }

    /**
     * 拜访步骤表单—— 删除（批量）——被禁用后的数据才能删除
     *
     * @param ids
     */
    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("请选择要删除的数据");
        }
        //校验数据是否被禁用，被禁用才能删除
        int count = this.count(Wrappers.lambdaQuery(SfaVisitStepFromEntity.class)
                .eq(SfaVisitStepFromEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .in(SfaVisitStepFromEntity::getId, ids));
        //有一条都会导致无法禁用
        if (count > 0) {
            throw new BusinessException("数据未禁用，无法删除");
        }
        this.update(Wrappers.lambdaUpdate(SfaVisitStepFromEntity.class)
                .set(SfaVisitStepFromEntity::getDelFlag, CrmDelFlagEnum.DELETE.getCode())
                .in(SfaVisitStepFromEntity::getId, ids));
        //删除缓存
        this.redisService.hdel(SfaVisitStepFromRespVo.redisHash().toString(), ids.toArray());
    }

    /**
     * 拜访步骤表单—— 启用（批量)
     *
     * @param ids
     */
    @Override
    public void enableBatch(List<String> ids) {
        this.update(Wrappers.lambdaUpdate(SfaVisitStepFromEntity.class)
                .set(SfaVisitStepFromEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .in(SfaVisitStepFromEntity::getId, ids));
    }

    /**
     * 拜访步骤表单—— 禁用（批量)
     *
     * @param ids
     */
    @Override
    public void disableBatch(List<String> ids) {
        this.update(Wrappers.lambdaUpdate(SfaVisitStepFromEntity.class)
                .set(SfaVisitStepFromEntity::getEnableStatus, CrmEnableStatusEnum.DISABLE.getCode())
                .in(SfaVisitStepFromEntity::getId, ids));
        //删除缓存
        this.redisService.hdel(SfaVisitStepFromRespVo.redisHash().toString(), ids.toArray());
    }


    /**
     * 封装查询条件
     *
     * @param SearchReqVo 查询条件Vo
     * @return com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper<com.biz.crm.visitstep.model.SfaVisitStepFromEntity>
     * @method getWrapper
     * @date: 2021/2/5 11:05
     * @author: YuanZiJian
     */
    private LambdaQueryWrapper<SfaVisitStepFromEntity> getWrapper(SfaVisitStepFromSearchReqVo SearchReqVo) {
        LambdaQueryWrapper<SfaVisitStepFromEntity> wrapper = Wrappers.lambdaQuery(SfaVisitStepFromEntity.class);
        if (StringUtils.isNotEmpty(SearchReqVo.getVisitType())) {
            wrapper.eq(SfaVisitStepFromEntity::getVisitType, SearchReqVo.getVisitType());
        }
        if (StringUtils.isNotEmpty(SearchReqVo.getCustomerType())) {
            wrapper.eq(SfaVisitStepFromEntity::getCustomerType, SearchReqVo.getCustomerType());
        }
        if (StringUtils.isNotEmpty(SearchReqVo.getClientSubclass())) {
            wrapper.eq(SfaVisitStepFromEntity::getClientSubclass, SearchReqVo.getClientSubclass());
        }


        if (StringUtils.isNotEmpty(SearchReqVo.getPageCode())) {
            wrapper.eq(SfaVisitStepFromEntity::getPageCode, SearchReqVo.getPageCode());
        }
        if (StringUtils.isNotEmpty(SearchReqVo.getStepCode())) {
            wrapper.eq(SfaVisitStepFromEntity::getStepCode, SearchReqVo.getStepCode());
        }
        if (StringUtils.isNotEmpty(SearchReqVo.getEnableStatus())) {
            wrapper.eq(SfaVisitStepFromEntity::getEnableStatus, SearchReqVo.getEnableStatus());
        }
        //对应条件存在就拼接模糊查询条件
        if (StringUtils.isNotEmpty(SearchReqVo.getFromName())) {
            wrapper.like(SfaVisitStepFromEntity::getFromName, SearchReqVo.getFromName());
        }

        //默认没有被删除且按照时间降序
        return wrapper.ne(SfaVisitStepFromEntity::getDelFlag, CrmDelFlagEnum.DELETE.getCode())
                .orderByDesc(SfaVisitStepFromEntity::getVisitType)
                .orderByDesc(SfaVisitStepFromEntity::getCreateDate)
                .orderByDesc(SfaVisitStepFromEntity::getCreateDateSecond);
    }


    /**
     * 检验基本字段
     *
     * @param sfaVisitStepFromReqVo 步骤表单接收参数Vo
     */
    private void checkVo(SfaVisitStepFromReqVo sfaVisitStepFromReqVo) {
        if (StringUtils.isEmpty(sfaVisitStepFromReqVo.getFromName())
                || StringUtils.isEmpty(sfaVisitStepFromReqVo.getTimeType())
                || StringUtils.isEmpty(sfaVisitStepFromReqVo.getPageCode())
                || StringUtils.isEmpty(sfaVisitStepFromReqVo.getStepCode())) {
            throw new BusinessException("未填写必填项");
        }
        if (SfaVisitEnum.ClientType.DEALER.getVal().equals(sfaVisitStepFromReqVo.getCustomerType())){
            sfaVisitStepFromReqVo.setClientSubclassName(DictUtil.dictValue(DictConstant.CUSTOMER_TYPE,sfaVisitStepFromReqVo.getClientSubclass()));
        }else {
            sfaVisitStepFromReqVo.setClientSubclassName(DictUtil.dictValue(DictConstant.TERMINAL_TYPE,sfaVisitStepFromReqVo.getClientSubclass()));
        }
        this.injectDefValues(sfaVisitStepFromReqVo);
        //如果没有配置拜访大类、客户类型、客户细类。那么为该步骤编码生成一个全局默认表单，且这个表单只可能有一个
        //如果配置的拜访大类是陌拜。
        if (StringUtils.isEmpty(sfaVisitStepFromReqVo.getCustomerType())
                && StringUtils.isEmpty(sfaVisitStepFromReqVo.getClientSubclass())
                && StringUtils.isEmpty(sfaVisitStepFromReqVo.getVisitType())) {
            sfaVisitStepFromReqVo.setId(sfaVisitStepFromReqVo.getStepCode());
        }


        //默认不获取定位信息
        if (StringUtils.isEmpty(sfaVisitStepFromReqVo.getLocateType())) {
            sfaVisitStepFromReqVo.setLocateType(YesNoEnum.yesNoEnum.NO.getValue());
        } else if (sfaVisitStepFromReqVo.getLocateType().equals(YesNoEnum.yesNoEnum.YES.getValue())) {
            AssertUtils.isNotEmpty(sfaVisitStepFromReqVo.getDistance(), "定位距离不能为空");
        }

        //若选择自定义有效期，校验时间
        if (VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(sfaVisitStepFromReqVo.getTimeType())) {
            String startTime = sfaVisitStepFromReqVo.getStartTime();
            String endTime = sfaVisitStepFromReqVo.getEndTime();
            if (StringUtils.isEmpty(startTime) && StringUtils.isEmpty(endTime)) {
                throw new BusinessException("未填写开始或结束时间");
            }
            int compare = LocalDate.parse(startTime).compareTo(LocalDate.parse(endTime));
            if (compare > 0) {
                throw new BusinessException("开始时间不能比结束时间大");
            }
        }
        //如果添加了模块需要校验模块中的必填项
        if (CollectionUtil.listNotEmpty(sfaVisitStepFromReqVo.getStepFromModelReqVoList())) {
            List<SfaVisitStepFromModelReqVo> stepFromModelReqVoList = sfaVisitStepFromReqVo.getStepFromModelReqVoList();
            stepFromModelReqVoList.stream().forEach(data -> {
                        if (StringUtils.isEmpty(data.getModelName())) {
                            throw new BusinessException("存在模块名称未填写");
                        }
                        //校验模块中的控件顺序是否填写
                        data.getSfaVisitStepFromControlReqVoList().forEach(item -> {
                            if (StringUtils.isEmpty(item.getSort())) {
                                throw new BusinessException("模块中存在控件顺序未填写");
                            }
                            //判断类型如果为附件，则需要进行字段校验
                            if (item.getControlType().equals(SfaVisitEnum.VISIT_CONTROL.file.getVal()) && !item.getFieldName().contains("obj")){
                                throw new BusinessException("附件列表的自定义字段名必须为'obj'相关的，例如:obj1,可选范围[obj1-obj10]");
                            }
                        });
                    }
            );
        }
    }

    private void injectDefValues(SfaVisitStepFromReqVo sfaVisitStepFromReqVo) {
        if (SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(sfaVisitStepFromReqVo.getVisitType())) {
            sfaVisitStepFromReqVo.setCustomerType(SfaVisitStepFromEntity.FORM_DEF_VAL);
            sfaVisitStepFromReqVo.setClientSubclass(SfaVisitStepFromEntity.FORM_DEF_VAL);
        } else {
            if (StringUtils.isEmpty(sfaVisitStepFromReqVo.getCustomerType())) {
                sfaVisitStepFromReqVo.setCustomerType(SfaVisitStepFromEntity.FORM_DEF_VAL);
            }
            if (StringUtils.isEmpty(sfaVisitStepFromReqVo.getClientSubclass())) {
                sfaVisitStepFromReqVo.setClientSubclass(SfaVisitStepFromEntity.FORM_DEF_VAL);
            }
            if (StringUtils.isEmpty(sfaVisitStepFromReqVo.getVisitType())) {
                sfaVisitStepFromReqVo.setVisitType(SfaVisitStepFromEntity.FORM_DEF_VAL);
            }
        }

    }


    /**
     * 步骤表单新增操作
     *
     * @param sfaVisitStepFromReqVo 步骤表单接收参数Vo
     * @return void
     * @method saveFrom
     * @date: 2021/2/5 13:36
     * @author: YuanZiJian
     */
    private SfaVisitStepFromRespVo saveFrom(SfaVisitStepFromReqVo sfaVisitStepFromReqVo) {
        SfaVisitStepFromEntity entity = CrmBeanUtil.copy(sfaVisitStepFromReqVo, SfaVisitStepFromEntity.class);
        if (org.apache.commons.lang3.StringUtils.isBlank(entity.getId())
                || this.lambdaQuery().eq(SfaVisitStepFromEntity::getId, entity.getId()).count() == 0) {
            this.save(entity);
        } else {
            this.lambdaUpdate()
                    .eq(SfaVisitStepFromEntity :: getId, entity.getId())
                    .set(SfaVisitStepFromEntity :: getVisitType, entity.getVisitType())
                    .set(SfaVisitStepFromEntity :: getCustomerType, entity.getCustomerType())
                    .set(SfaVisitStepFromEntity :: getClientSubclass, entity.getClientSubclass())
                    .set(SfaVisitStepFromEntity :: getClientSubclassName, entity.getClientSubclassName())
                    .set(SfaVisitStepFromEntity :: getRemarks, entity.getRemarks())
                    .set(SfaVisitStepFromEntity :: getLocateType, entity.getLocateType())
                    .set(SfaVisitStepFromEntity :: getDistance,entity.getDistance())
                    .set(SfaVisitStepFromEntity :: getTimeType, entity.getTimeType())
                    .set(SfaVisitStepFromEntity :: getStartTime, entity.getStartTime())
                    .set(SfaVisitStepFromEntity :: getEndTime, entity.getEndTime())
                    .set(SfaVisitStepFromEntity :: getFromName, entity.getFromName())
                    .set(SfaVisitStepFromEntity :: getIcon, entity.getIcon())
                    .update();
        }

        //设置与模块关联的fromId
        List<SfaVisitStepFromModelReqVo> stepFromModelReqVoList = sfaVisitStepFromReqVo.getStepFromModelReqVoList();
        if (CollectionUtil.listNotEmpty(stepFromModelReqVoList)) {
            stepFromModelReqVoList.forEach(data -> {
                //保存模块信息
                SfaVisitStepFromModelEntity modelEntity = CrmBeanUtil.copy(data, SfaVisitStepFromModelEntity.class);
                modelEntity.setFromId(entity.getId());
                modelEntity.setModelIcon(JsonPropertyUtil.toJsonString(data.getModelIcon()));
                //设置排序
                modelEntity.setModelSort((++sort) + "");
                iSfaVisitStepFromModelService.save(modelEntity);
                List<SfaVisitStepFromControlReqVo> sfaVisitStepFromControlReqVoList = data.getSfaVisitStepFromControlReqVoList();
                //保存模块中的每个控件信息
                if (CollectionUtil.listNotEmpty(sfaVisitStepFromControlReqVoList)) {
                    List<SfaVisitStepFromControlEntity> sfaVisitStepFromControlEntities = CrmBeanUtil.copyList(sfaVisitStepFromControlReqVoList, SfaVisitStepFromControlEntity.class);
                    sfaVisitStepFromControlEntities.forEach(item -> {
                        item.setModelId(modelEntity.getId());
                    });
                    iSfaVisitStepFromControlService.saveBatch(sfaVisitStepFromControlEntities);
                }
            });
        }
        return CrmBeanUtil.copy(entity, SfaVisitStepFromRespVo.class);
    }

    /**
     * 步骤表单更新操作
     *
     * @param sfaVisitStepFromReqVo
     * @return void
     * @method updateFrom
     * @date: 2021/2/5 13:47
     * @author: YuanZiJian
     */
    private void updateFrom(SfaVisitStepFromReqVo sfaVisitStepFromReqVo) {
        //根据fromId查询模块
        List<SfaVisitStepFromModelEntity> fromModelEntities = iSfaVisitStepFromModelService.list(Wrappers.lambdaQuery(SfaVisitStepFromModelEntity.class).eq(SfaVisitStepFromModelEntity::getFromId, sfaVisitStepFromReqVo.getId()));
        //根据模块id删除对应的模块信息
        if (CollectionUtil.listNotEmpty(fromModelEntities)) {
            List<String> modelId = fromModelEntities.stream().map(SfaVisitStepFromModelEntity::getId).collect(Collectors.toList());
            iSfaVisitStepFromControlService.remove(Wrappers.lambdaQuery(SfaVisitStepFromControlEntity.class).in(SfaVisitStepFromControlEntity::getModelId, modelId));
            iSfaVisitStepFromModelService.remove(Wrappers.lambdaQuery(SfaVisitStepFromModelEntity.class).in(SfaVisitStepFromModelEntity::getId, modelId));
        }
        //保存
        saveFrom(sfaVisitStepFromReqVo);

        //删除缓存
        this.redisService.hdel(SfaVisitStepFromRespVo.redisHash().toString(), sfaVisitStepFromReqVo.getId());
    }

}
