package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepHelpScoreMapper;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreDetailEntity;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreEntity;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreEsData;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepHelpScoreEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepHelpScoreDetailService;
import com.biz.crm.visitstep.service.ISfaVisitStepHelpScoreService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 拜访步骤(协访评价);接口实现
 *
 * @author lf
 * @date 2020-12-29 11:35:55
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitStepHelpScoreServiceExpandImpl")
@Transactional
public class SfaVisitStepHelpScoreServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepHelpScoreMapper, SfaVisitStepHelpScoreEntity> implements ISfaVisitStepHelpScoreService, VisitDataDurabilityService {

    @Resource
    private SfaVisitStepHelpScoreEsDataRepositories sfaVisitStepHelpScoreEsDataRepositories;
    @Resource
    private ISfaVisitStepHelpScoreDetailService sfaVisitStepHelpScoreDetailService;


    /**
     * ########## 请务必保证接口的幂等性 ###########
     * 拜访数据持久化
     * @param baseEntity
     * @return
     */
    @Override
    @Transactional
    public  List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if(CollectionUtils.isEmpty(baseEntity)){
            return Lists.newArrayList();
        }
        SfaVisitStepHelpScoreRedisData redisData = (SfaVisitStepHelpScoreRedisData)(baseEntity.get(0));
        baseEntity = Lists.newArrayList(this.save(redisData));
        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    /**
     * 新增
     *
     * @param redisData
     * @return
     */
    @Override
    @Transactional
    public SfaVisitStepHelpScoreRedisData save(SfaVisitStepHelpScoreRedisData redisData) {
        this.saveOrUpdate(redisData);
        this.sfaVisitStepHelpScoreDetailService.remove(Wrappers.lambdaQuery(SfaVisitStepHelpScoreDetailEntity.class)
                .eq(SfaVisitStepHelpScoreDetailEntity :: getHelpScoreId, redisData.getId()));
        //协访评价明细
        List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList = redisData.getHelpScoreDetailList();
        if(!CollectionUtils.isEmpty(helpScoreDetailList)){
            List<SfaVisitStepHelpScoreDetailEntity> itemEntities = helpScoreDetailList.stream().map(v -> {
                SfaVisitStepHelpScoreDetailEntity copy = CrmBeanUtil.copy(v, SfaVisitStepHelpScoreDetailEntity.class);
                copy.setHelpScoreId(redisData.getId());
                return copy;
            }).collect(Collectors.toList());
            this.sfaVisitStepHelpScoreDetailService.saveOrUpdateBatch(itemEntities);
        }
        return redisData;
    }

    /**
     *  推送ES
     * @param redisData
     */
    protected void doTransToEs(SfaVisitStepHelpScoreRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepHelpScoreEsData dataResp = CrmBeanUtil.copy(redisData, SfaVisitStepHelpScoreEsData.class);
        dataResp.setHelpScoreDetailList(redisData.getHelpScoreDetailList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if(StringUtils.isNotBlank(dataResp.getVisitPlanInfoId())){
            SfaVisitStepHelpScoreEsData oldData = this.sfaVisitStepHelpScoreEsDataRepositories.findByVisitPlanInfoIdAndStepCode(dataResp.getVisitPlanInfoId(), dataResp.getStepCode());
            if(null != oldData){
                dataResp.setId(oldData.getId());
            }
        }
        this.sfaVisitStepHelpScoreEsDataRepositories.save(dataResp);
    }













}
