package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInStoreReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInoutReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOutStoreReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepInoutRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.mapper.SfaVisitStepInoutMapper;
import com.biz.crm.visitstep.model.SfaVisitStepInoutEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepInoutService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访步骤(进离店) 接口实现
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaVisitStepInoutServiceExpandImpl")
public class SfaVisitStepInoutServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepInoutMapper, SfaVisitStepInoutEntity> implements ISfaVisitStepInoutService {

    @Resource
    private SfaVisitStepInoutMapper sfaVisitStepInoutMapper;

    @Autowired
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitStepInoutRespVo> findList(SfaVisitStepInoutReqVo reqVo){
        Page<SfaVisitStepInoutRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepInoutRespVo> list = sfaVisitStepInoutMapper.findList(page, reqVo);
        return PageResult.<SfaVisitStepInoutRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitStepInoutRespVo
     */
    @Override
    public SfaVisitStepInoutRespVo query(SfaVisitStepInoutReqVo reqVo){
        SfaVisitStepInoutEntity sfaVisitStepInoutEntity = this.getById(reqVo.getId());
        return CrmBeanUtil.copy(sfaVisitStepInoutEntity,SfaVisitStepInoutRespVo.class);
    }

    /**
     * 进店
     * @param sfaVisitStepInStoreReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveInStore(SfaVisitStepInStoreReqVo sfaVisitStepInStoreReqVo){
        QueryWrapper<SfaVisitStepInoutEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.eq("del_flag",CrmDelFlagEnum.NORMAL.getCode());
        queryWrapper.eq("visit_id",sfaVisitStepInStoreReqVo.getVisitId());
        List<SfaVisitStepInoutEntity> sfaVisitStepInoutEntities = this.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(sfaVisitStepInoutEntities)){
            throw new BusinessException("数据异常，已存在进店数据");
        }

        SfaVisitStepInoutEntity entity = CrmBeanUtil.copy(sfaVisitStepInStoreReqVo,SfaVisitStepInoutEntity.class);

        //查询拜访计划明细
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = sfaVisitPlanInfoService.getById(sfaVisitStepInStoreReqVo.getVisitId());

        entity.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
//        entity.setClientId(sfaVisitPlanInfoEntity.getClientId());
        entity.setClientName(sfaVisitPlanInfoEntity.getClientName());
        entity.setClientType(sfaVisitPlanInfoEntity.getClientType());
        entity.setVisitDate(sfaVisitPlanInfoEntity.getVisitDate());
        entity.setVisitType(sfaVisitPlanInfoEntity.getVisitType());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);

    }

    /**
     * 离店
     * @param sfaVisitStepOutStoreReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOutStore(SfaVisitStepOutStoreReqVo sfaVisitStepOutStoreReqVo){
        QueryWrapper<SfaVisitStepInoutEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.eq("del_flag",CrmDelFlagEnum.NORMAL.getCode());
        queryWrapper.eq("visit_id",sfaVisitStepOutStoreReqVo.getVisitId());
        List<SfaVisitStepInoutEntity> sfaVisitStepInoutEntities = this.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(sfaVisitStepInoutEntities)){
            throw new BusinessException("数据异常，未找到进店数据");
        }

        SfaVisitStepInoutEntity entity = this.getById(sfaVisitStepOutStoreReqVo.getId());
        //属性copy
        CrmBeanUtil.copyPropertiesIgnoreEmpty(sfaVisitStepOutStoreReqVo,entity);

        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaVisitStepInoutReqVo reqVo){
        List<SfaVisitStepInoutEntity> sfaVisitStepInoutEntities = sfaVisitStepInoutMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepInoutEntities)){
            sfaVisitStepInoutEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepInoutEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaVisitStepInoutReqVo reqVo){
        //设置状态为启用
        List<SfaVisitStepInoutEntity> sfaVisitStepInoutEntities = sfaVisitStepInoutMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepInoutEntities)){
            sfaVisitStepInoutEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepInoutEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaVisitStepInoutReqVo reqVo){
        //设置状态为禁用
        List<SfaVisitStepInoutEntity> sfaVisitStepInoutEntities = sfaVisitStepInoutMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepInoutEntities)){
                sfaVisitStepInoutEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepInoutEntities);
    }
}
