package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.enums.SfaWorkSummaryEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.distributionorder.DistributionOrderVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailExecuteRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.mapper.SfaTpmActMapper;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailExecuteService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderMapper;
import com.biz.crm.visitstep.model.*;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.req.GetOrderPageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstepbase.VisitBaseCheck;
import com.biz.crm.visitstepbase.VisitBaseComponent;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

/**
 * 拜访步骤(订单主表);接口实现
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitStepOrderServiceExpandImpl")
@Transactional
public class SfaVisitStepOrderServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepOrderMapper, SfaVisitStepOrderEntity> implements ISfaVisitStepOrderService, VisitDataDurabilityService {

  @Resource
  private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;
  @Resource
  private MdmTerminalFeign mdmTerminalFeign;
  @Resource
  private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;
  @Resource
  private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;
  @Resource
  private RedisService redisService;
  @Resource
  private VisitBaseComponent visitBaseComponent;
  @Autowired
  private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
  @Resource
  private SfaVisitStepOrderMapper sfaVisitStepOrderMapper;
  @Autowired
  private ISfaTpmActDetailService sfaTpmActDetailService;
  @Autowired
  private ISfaTpmActDetailExecuteService sfaTpmActDetailExecuteService;
  @Resource
  private SfaTpmActMapper sfaTpmActMapper;

  /**
   * ########## 请务必保证接口的幂等性 ###########
   * 拜访数据持久化
   *
   * @param baseEntity
   * @return
   */
  @Override
  @Transactional
  public List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
    if (CollectionUtils.isEmpty(baseEntity)) {
      return Lists.newArrayList();
    }
    SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData) (baseEntity.get(0));
    baseEntity = Lists.newArrayList(this.save(redisData));
    //新增订单不走审批，直接将数据写入绩效记录表
    this.setAchievement(redisData);
    this.doTransToEs(redisData, fromRespVo);
    return baseEntity;
  }

  /**
   * 指标完成，添加绩效
   *
   * @param redisData
   */
  private void setAchievement(SfaVisitStepOrderEntity redisData) {
    UserRedis user = UserUtils.getUser();
    SfaAchievementAccomplishRecordReqVo reqVo = new SfaAchievementAccomplishRecordReqVo();
    reqVo.setCustomerCode(redisData.getClientCode())
            .setRelationId(redisData.getId())
            .setIndexCode(SfaVisitEnum.indexType.XD.getCode())
            .setCustomerCode(redisData.getClientCode())
            .setUsername(user.getUsername())
            .setObjectPosCode(user.getPoscode())
            .setCreateOrgCode(user.getOrgcode());
    AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo);
  }

  /**
   * 新增
   *
   * @param redisData
   * @return
   */
  @Override
  @Transactional
  public SfaVisitStepOrderRedisData save(SfaVisitStepOrderRedisData redisData) {
    if (org.apache.commons.lang3.StringUtils.isBlank(redisData.getOrderCode())) {
      redisData.setOrderCode(CodeUtil.generateCode(SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
//            redisData.setOrderCode(CodeUtil.getCodeDefault());
    }
    this.saveOrUpdate(redisData);
    this.sfaVisitStepOrderItemService.remove(Wrappers.lambdaQuery(SfaVisitStepOrderItemEntity.class)
            .eq(SfaVisitStepOrderItemEntity::getOrderId, redisData.getId()));
    //竞品商品清单
    List<OrderAsDataReq.OrderItemAsReqVo> orderItems = redisData.getSfaVisitStepOrderItems();
    if (!CollectionUtils.isEmpty(orderItems)) {
      List<SfaVisitStepOrderItemEntity> itemEntities = orderItems.stream().map(v -> {
        SfaVisitStepOrderItemEntity copy = CrmBeanUtil.copy(v, SfaVisitStepOrderItemEntity.class);
        copy.setOrderId(redisData.getId());
        return copy;
      }).collect(Collectors.toList());
      this.sfaVisitStepOrderItemService.saveOrUpdateBatch(itemEntities);
    }
    return redisData;

  }

  /**
   * 推送ES
   *
   * @param redisData
   */
  protected void doTransToEs(SfaVisitStepOrderRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
    SfaVisitStepOrderEsData dataResp = CrmBeanUtil.copy(redisData, SfaVisitStepOrderEsData.class);
    dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
    dataResp.setSfaVisitStepFrom(fromRespVo);

    if (StringUtils.isBlank(dataResp.getOrderCode())) {
      redisData.setOrderCode(CodeUtil.generateCode(SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
    }

    this.sfaVisitStepOrderEsDataRepositories.save(dataResp);
  }


  /**
   * 查询终端供货经销商
   *
   * @param terminalCode
   * @return
   */
  @Override
  public List<MdmTerminalSupplyVo> findTerminalSupplyList(String terminalCode) {
    List<MdmTerminalSupplyVo> mdmTerminalSupplyVos = Lists.newArrayList();
    Result<MdmTerminalVo> mdmTerminalVoResult = mdmTerminalFeign.query(null, terminalCode);
    if (mdmTerminalVoResult.isSuccess() && mdmTerminalVoResult.getResult() != null) {
      if (CollectionUtil.listNotEmptyNotSizeZero(mdmTerminalVoResult.getResult().getSupplys())) {
        mdmTerminalSupplyVos = mdmTerminalVoResult.getResult().getSupplys();
      }
    }
    return mdmTerminalSupplyVos;
  }


  /**
   * 获取订单数
   * dateFlag 1.今日  2.本周  3.本月
   */
  @Override
  public Integer getOrderNum(String dateFlag) {
    AssertUtils.isNotEmpty(dateFlag, "请传入查询时间范围类型——本日、本周、本月");
    UserRedis user = UserUtils.getUser();
    LocalDate nowTime = LocalDate.now();
    LambdaQueryWrapper<SfaAchievementAccomplishRecordEntity> queryWrapper = Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
            .eq(SfaAchievementAccomplishRecordEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
            .eq(SfaAchievementAccomplishRecordEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
            .eq(SfaAchievementAccomplishRecordEntity::getIndexCode, SfaVisitEnum.indexType.XD.getCode())
            .eq(SfaAchievementAccomplishRecordEntity::getUsername, user.getUsername());
    //今日
    if (SfaWorkSummaryEnum.dateFlag.TODAY.getCode().equals(dateFlag)) {
      String dayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
      queryWrapper.eq(SfaAchievementAccomplishRecordEntity::getCreateDate, dayTime);
    }
    //本周
    if (SfaWorkSummaryEnum.dateFlag.WEEK.getCode().equals(dateFlag)) {
      //本周第一天
      String weekTime = nowTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).format(CrmDateUtils.yyyyMMdd);
      //当前日期
      String nowDayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
      queryWrapper.between(SfaAchievementAccomplishRecordEntity::getCreateDate, weekTime, nowDayTime);
    }
    //本月
    if (SfaWorkSummaryEnum.dateFlag.MONTH.getCode().equals(dateFlag)) {
      String monthTime = nowTime.format(DateTimeFormatter.ofPattern("yyyy-MM"));
      queryWrapper.like(SfaAchievementAccomplishRecordEntity::getCreateDate, monthTime);
    }
    int count = sfaAchievementAccomplishRecordService.count(queryWrapper);
    return count;
  }

  /**
   * tpm活动-工作台分销订单保存
   *
   * @param vo
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public String saveWorkBenchDistributionOrder(DistributionOrderVo vo) {
    List<DistributionOrderVo.DistributionOrderItem> orderItemList = this.checkDistributionOrder(vo);
    SfaVisitStepOrderEntity orderEntity = CrmBeanUtil.copy(vo, SfaVisitStepOrderEntity.class);
    if (StringUtils.isBlank(vo.getOrderCode())) {
      orderEntity.setOrderCode(CodeUtil.generateCode(SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
    }
    if (StringUtils.isNotBlank(vo.getVisitPlanInfoId())) {
      SfaVisitStepOrderEntity oldEntity = this.lambdaQuery()
              .eq(SfaVisitStepOrderEntity::getVisitPlanInfoId, vo.getVisitPlanInfoId())
              .eq(SfaVisitStepOrderEntity::getActDetailCode, vo.getActDetailCode()).one();
      if (oldEntity != null) {
        orderEntity.setId(oldEntity.getId());
      }
    }
    //组装实体
    this.buildEntity(orderEntity, vo.getClientCode());
    //进行金额校验
    visitBaseComponent.checkTpmActDistributionOrderAmount(vo.getActDetailCode(), vo.getTotalPrice(), vo.getClientCode());
    this.saveOrUpdate(orderEntity);
    //绩效
    this.setAchievement(orderEntity);
    vo.setId(orderEntity.getId());
    this.sfaVisitStepOrderItemService.remove(Wrappers.lambdaQuery(SfaVisitStepOrderItemEntity.class)
            .eq(SfaVisitStepOrderItemEntity::getOrderId, orderEntity.getId()));

    List<SfaVisitStepOrderItemEntity> itemEntities = orderItemList.stream().map(item -> {
      SfaVisitStepOrderItemEntity itemEntity = CrmBeanUtil.copy(item, SfaVisitStepOrderItemEntity.class);
      itemEntity.setUnit(item.getSaleUnit());
      itemEntity.setUnitName(item.getSaleUnitName());
      itemEntity.setOrderId(orderEntity.getId());
      return itemEntity;
    }).collect(Collectors.toList());

    this.sfaVisitStepOrderItemService.saveBatch(itemEntities);
    this.redisService.hmset(DistributionOrderVo.getRedisHashKey(orderEntity.getId()), DistributionOrderVo.buildMap(orderEntity.getId(), vo), DistributionOrderVo.redis_expire_time);
    //进行金额的缓存修改
    visitBaseComponent.saveOrderSetTpmActAmount(vo.getActDetailCode(), vo.getClientCode());
    //进行业务动态的保存
    orderEntity.setId(orderEntity.getActDetailCode());
    visitBaseComponent.tpmDoListener(orderEntity);
    //保存活动执行数据
    SfaTpmActDetailExecuteRespVo executeRespVo = new SfaTpmActDetailExecuteRespVo();
    executeRespVo.setTerminalCode(vo.getClientCode());
    executeRespVo.setActDetailCode(vo.getActDetailCode());
    sfaTpmActDetailExecuteService.saveTpmActExecute(executeRespVo);
    return orderEntity.getId();
  }

  @Override
  public DistributionOrderVo loadTpmActDistributionOrderDetail(String id, String actDetailCode) {
    Object obj = redisService.hmget(DistributionOrderVo.getRedisHashKey(id), id);
    DistributionOrderVo orderVo = new DistributionOrderVo();
    if (null == obj) {
      SfaVisitStepOrderEntity entity = this.lambdaQuery()
              .eq(SfaVisitStepOrderEntity::getId, id).one();
      if (null == entity) {
        throw new BusinessException("主键id错误,未查询到分销订单信息");
      }
      orderVo = CrmBeanUtil.copy(entity, DistributionOrderVo.class);
      List<SfaVisitStepOrderItemEntity> itemEntityList = this.sfaVisitStepOrderItemService.lambdaQuery()
              .eq(SfaVisitStepOrderItemEntity::getOrderId, id).list();
      Map<String, List<SfaVisitStepOrderItemEntity>> itemMap = itemEntityList.stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemEntity::getItmeType));
      if (null != itemMap && itemMap.size() > 0) {
        for (Map.Entry<String, List<SfaVisitStepOrderItemEntity>> data : itemMap.entrySet()) {
          List<DistributionOrderVo.DistributionOrderItem> orderItems = CrmBeanUtil.copyList(data.getValue(), DistributionOrderVo.DistributionOrderItem.class);
          if (data.getKey().equals(SfaActivityEnum.bpItemType.bp.getVal())) {
            orderVo.setBpProductList(orderItems);
          } else {
            orderVo.setZpProductList(orderItems);
          }
        }
      }
    } else {
      orderVo = (DistributionOrderVo) obj;
    }
    this.redisService.hmset(DistributionOrderVo.getRedisHashKey(id), DistributionOrderVo.buildMap(id, orderVo), DistributionOrderVo.redis_expire_time);
    if (com.biz.crm.util.StringUtils.isNotEmpty(actDetailCode)) {
      SfaTpmActRespVo tpmActInfo = sfaTpmActMapper.findTpmActInfo(actDetailCode);
      orderVo.setSfaTpmActRespVo(tpmActInfo);
    }
    return orderVo;
  }

  /**
   * 拜访步骤-tpm活动-分销订单采集
   *
   * @param vo
   */
  @Override
  public String saveVisitStepDistributionOrder(VisitBaseVo<DistributionOrderVo> vo) {
    //基础数据校验
    VisitBaseCheck.checkBaseData(vo);
    DistributionOrderVo orderVo = vo.getStepExecuteData();
    orderVo.setStepCode(SfaVisitEnum.visitStep.tpm);
    orderVo.setFormId(vo.getFormId());
    SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(vo.getRedisHashKey());
    SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(vo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
    orderVo.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
    orderVo.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
    SfaVisitStepFromRespVo fromRespVo = visitBaseComponent.getFormData(vo.getFormId(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
    //判断为不是离线数据
    if (null == orderVo.getLineStatus() || SfaVisitEnum.VISIT_OFF_LINE.online.getVal().equals(orderVo.getLineStatus())) {
      VisitBaseCheck.checkVisitStepDistance(sfaVisitPlanInfoEntity, fromRespVo, orderVo.getLongitude(), orderVo.getLatitude());
    }
    //状态更新
    visitBaseComponent.updateStepStatus(vo.getRedisHashKey(), fromRespVo.getStepCode(), visitRedisHashKey.getVisitBigType());
    return this.saveWorkBenchDistributionOrder(orderVo);
  }

  /**
   * web端-查询订单明细报表
   *
   * @param reqVo
   * @return
   */
  @Override
  public PageResult<SfaVisitStepOrderRespVo> orderDetailReport(SfaVisitStepOrderReqVo reqVo) {
    Page<SfaVisitStepOrderRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
    List<SfaVisitStepOrderRespVo> list = sfaVisitStepOrderMapper.findOrderReportList(page, reqVo);
    return PageResult.<SfaVisitStepOrderRespVo>builder()
            .count(page.getTotal())
            .data(list)
            .build();
  }

  /**
   * 工作台-查询订单采集列表
   *
   * @param req
   * @return
   */
  @Override
  public PageResult<SfaVisitStepOrderRespVo> getWorkbenchOrderPage(GetOrderPageReq req) {
    Page<SfaVisitStepOrderRespVo> page = new Page<>(req.getPageNum(), req.getPageSize());
    if (StringUtils.isBlank(req.getPosCode()) && StringUtils.isBlank(req.getPosName())) {
      req.setPosCode(UserUtils.getUser().getPoscode());
    }
    List<SfaVisitStepOrderRespVo> list = sfaVisitStepOrderMapper.findWorkbenchOrderPage(page, req);
    if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
      List<String> orderIds = list.stream().map(SfaVisitStepOrderRespVo::getId).collect(Collectors.toList());
      Map<String, List<SfaVisitStepOrderItemEntity>> itemListMap = this.sfaVisitStepOrderItemService.lambdaQuery()
              .in(SfaVisitStepOrderItemEntity::getOrderId, orderIds)
              .select(SfaVisitStepOrderItemEntity::getQuantity, SfaVisitStepOrderItemEntity::getPrice,
                      SfaVisitStepOrderItemEntity::getProductCode, SfaVisitStepOrderItemEntity::getProductName,
                      SfaVisitStepOrderItemEntity::getSeriesCode, SfaVisitStepOrderItemEntity::getSeriesName,
                      SfaVisitStepOrderItemEntity::getOrderId).list()
              .stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemEntity::getOrderId));
      list.forEach(resp -> {
        if (itemListMap.containsKey(resp.getId())) {
          List<SfaVisitStepOrderItemEntity> itemList = itemListMap.get(resp.getId());
          BigDecimal priceTotal = itemList.stream().filter(item -> item.getPrice() != null)
                  .map(SfaVisitStepOrderItemEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
          BigDecimal quantityTotal = itemList.stream().filter(item -> item.getQuantity() != null)
                  .map(SfaVisitStepOrderItemEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
          StringJoiner productName = new StringJoiner(",");
          StringJoiner productCode = new StringJoiner(",");
          StringJoiner seriesCode = new StringJoiner(",");
          StringJoiner seriesName = new StringJoiner(",");
          itemList.forEach(item -> {
            productName.add(item.getProductName());
            productCode.add(item.getProductCode());
            seriesCode.add(item.getSeriesCode());
            seriesName.add(item.getSeriesName());
          });
          resp.setProductCode(productCode.toString());
          resp.setProductName(productName.toString());
          resp.setSeriesCode(seriesCode.toString());
          resp.setSeriesName(seriesName.toString());
          resp.setQuantity(quantityTotal);
          resp.setTotalPrice(priceTotal);
        }
      });
    }
    return PageResult.<SfaVisitStepOrderRespVo>builder()
            .count(page.getTotal())
            .data(list)
            .build();
  }

  @Override
  public List<SfaVisitStepOrderEntity> findByActCodes(List<String> actCodes) {
    if (CollectionUtils.isEmpty(actCodes)) {
      return Lists.newArrayList();
    }
    QueryWrapper<SfaVisitStepOrderEntity> wrapper = new QueryWrapper<>();
    wrapper.in("act_detail_code", actCodes);
    return this.baseMapper.selectList(wrapper);
  }

  /**
   * 校验tpm活动 分销订单数据
   *
   * @param vo
   * @return
   */
  protected List<DistributionOrderVo.DistributionOrderItem> checkDistributionOrder(DistributionOrderVo vo) {
    List<DistributionOrderVo.DistributionOrderItem> orderItems = new ArrayList<>();
    AssertUtils.isNotEmpty(vo.getActDetailCode(), "活动编码为空");
    AssertUtils.isNotEmpty(vo.getClientCode(), "终端编码为空");
    AssertUtils.isNotEmpty(vo.getClientName(), "终端名称为空");
    AssertUtils.isNotEmpty(vo.getCustomerCode(), "上级客户编码为空");
    AssertUtils.isNotEmpty(vo.getCustomerName(), "上级客户名称为空");
    AssertUtils.isNotEmpty(vo.getContacts(), "联系人为空");
    AssertUtils.isNotEmpty(vo.getTelephone(), "联系电话为空");
    AssertUtils.isNotEmpty(vo.getAddress(), "收货地址为空");
    AssertUtils.isNotEmpty(vo.getExpectReceive(), "期望到货时间为空");
    AssertUtils.isNotEmpty(vo.getBpProductList(), "本品列表为空");
    //查询活动商品列表
    Map<String, SfaTpmActDetailProductEntity> productMap = this.sfaTpmActDetailProductService.lambdaQuery()
            .eq(SfaTpmActDetailProductEntity::getActDetailCode, vo.getActDetailCode())
            .list()
            .stream().collect(Collectors.toMap(data -> data.getProductCode() + data.getIsGiftProduct(), k -> k));
    //查询活动是否为折让活动
    SfaTpmActDetailEntity actDetailEntity = sfaTpmActDetailService.lambdaQuery()
            .eq(SfaTpmActDetailEntity::getActDetailCode, vo.getActDetailCode())
            .select(SfaTpmActDetailEntity::getHdCommitment).one();
    vo.getBpProductList().forEach(data -> {
      AssertUtils.isNotEmpty(data.getProductCode(), "本品-产品编码为空");
      AssertUtils.isNotEmpty(data.getProductName(), "本品-产品名称为空");
      if (data.getQuantity() == null) {
        throw new BusinessException("本品-" + data.getProductName() + "数量为空");
      }
      if (data.getPrice() == null) {
        throw new BusinessException("本品-" + data.getProductName() + "价格为空");
      }
      String key = data.getProductCode() + YesNoEnum.yesNoEnum.Y.getValue();
      if (productMap.containsKey(key)) {
        data.setSaleUnit(productMap.get(key).getSaleUnit());
        data.setSaleUnitName(productMap.get(key).getSaleUnitName());
      }
      data.setItmeType(SfaActivityEnum.bpItemType.bp.getVal());
      orderItems.add(data);
    });
    BigDecimal totalPrice = BigDecimal.ZERO;
    if (actDetailEntity != null && actDetailEntity.getHdCommitment() != null) {
      totalPrice = vo.getBpProductList().stream().map(data -> actDetailEntity.getHdCommitment().multiply(data.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
    } else {
      totalPrice = vo.getBpProductList().stream().map(data -> data.getPrice().multiply(data.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
    vo.setTotalPrice(totalPrice);
    Map<String, Object> map = (Map<String, Object>) redisService.hmget(SfaTpmActDetailRespVo.buildRedisKey(vo.getActDetailCode()));
    if (map.containsValue(SfaActivityEnum.bpItemType.zp.getVal())) {
      AssertUtils.isNotEmpty(vo.getZpProductList(), "赠品列表为空");
      vo.getZpProductList().forEach(data -> {
        AssertUtils.isNotEmpty(data.getProductCode(), "赠品-产品编码为空");
        AssertUtils.isNotEmpty(data.getProductName(), "赠品-产品名称为空");
        if (data.getQuantity() == null) {
          throw new BusinessException("赠品-" + data.getProductName() + "数量为空");
        }
//                if (data.getPrice()==null){
//                    throw new BusinessException("赠品-"+data.getProductName()+"价格为空");
//                }

        data.setItmeType(SfaActivityEnum.bpItemType.zp.getVal());
        orderItems.add(data);
      });
      if (actDetailEntity != null && actDetailEntity.getHdCommitment() != null) {
        totalPrice = vo.getZpProductList().stream().map(data -> actDetailEntity.getHdCommitment().multiply(data.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
      } else {
        totalPrice = vo.getZpProductList().stream().map(data -> data.getPrice().multiply(data.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
      }
      vo.setTotalPrice(totalPrice);
    }
    return orderItems;
  }

  /**
   * 组装终端信息到orderEntity
   *
   * @param entity
   * @param terminalCode
   */
  protected void buildEntity(SfaVisitStepOrderEntity entity, String terminalCode) {
    Result<MdmTerminalVo> terminalResult = mdmTerminalFeign.query(null, terminalCode);
    if (null != terminalResult && terminalResult.isSuccess() && terminalResult.getResult() != null) {
      MdmTerminalVo terminalVo = terminalResult.getResult();
      entity.setClientPhoto(terminalVo.getShopImagePath());
      entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
      entity.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
      List<MdmTerminalContactVo> mdmTerminalContactVos = terminalVo.getContacts();
      if (!CollectionUtils.isEmpty(mdmTerminalContactVos)) {
        entity.setClientPhone(mdmTerminalContactVos.get(0).getContactPhone());
      }
      entity.setClientSubclass(terminalVo.getTerminalType());
      entity.setClientSubclassName(terminalVo.getTerminalTypeName());
    } else {
      throw new BusinessException("未查询到该终端信息,终端编码[" + terminalResult + "]");
    }
    UserRedis userRedis = UserUtils.getUser();
    entity.setUserName(userRedis.getUsername());
    entity.setRealName(userRedis.getRealname());
    entity.setPosCode(userRedis.getPoscode());
    entity.setPosName(userRedis.getPosname());
    entity.setOrgCode(userRedis.getOrgcode());
    entity.setOrgName(userRedis.getOrgname());

    entity.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
    entity.setOrderDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
    entity.setOrderYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
    entity.setOrderYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
    entity.setOrderSource(SfaOrderSourceEnum.TPMACT.getCode());
    entity.setOrderSourceName(SfaOrderSourceEnum.TPMACT.getDesc());
    //TODO tpm活动订单暂时设置成正常状态
    entity.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
    entity.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.NORMAL.getDesc());
  }


}
