package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStockReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStockRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepStockMapper;
import com.biz.crm.visitstep.model.SfaVisitStepStockEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepStockService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访步骤(库存盘点);接口实现
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaVisitStepStockServiceExpandImpl")
public class SfaVisitStepStockServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepStockMapper, SfaVisitStepStockEntity> implements ISfaVisitStepStockService {

    @Resource
    private SfaVisitStepStockMapper sfaVisitStepStockMapper;



    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitStepStockReqVo reqVo){
        SfaVisitStepStockEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitStepStockEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);
    }


}
