package com.biz.crm.visitstep.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaVisitRoleEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStoreCheckReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaAttachmentRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStoreCheckRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.mapper.SfaVisitStepStoreCheckMapper;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEsData;
import com.biz.crm.visitstep.repositories.SfaVisitStepStoreCheckEsDataRepositories;
import com.biz.crm.visitstep.req.GetStoreCheckPageReq;
import com.biz.crm.visitstep.req.GetStoreCheckReq;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreCheckTableRespVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;


/**
 * 店面检查;ES实现
 *  @author: luoqi
 *  @Date: 2021-3-11 14:26
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Service
public class SfaVisitStepStoreCheckServiceEsImpl {

    @Resource
    private SfaVisitStepStoreCheckEsDataRepositories sfaVisitStepStoreCheckEsDataRepositories;
    @Resource
    private SfaVisitStepStoreCheckMapper sfaVisitStepStoreCheckMapper;



    /**
     * 查询店面检查分页
     * @param req
     * @return
     */
    public PageResult<SfaVisitStepStoreCheckRespVo> getWorkbenchStoreCheckPage(GetStoreCheckPageReq req){

//        //执行,返回包装结果的分页
//        org.springframework.data.domain.Page<SfaVisitStepStoreCheckEsData> list = this.sfaVisitStepStoreCheckEsDataRepositories.search(req.buildQuery());
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SfaVisitStepStoreCheckRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        SfaVisitStepStoreCheckReqVo reqVo = CrmBeanUtil.copy(req, SfaVisitStepStoreCheckReqVo.class);
        List<SfaVisitStepStoreCheckRespVo> list = this.sfaVisitStepStoreCheckMapper.findList(page, reqVo);
        return PageResult.<SfaVisitStepStoreCheckRespVo>builder()
                .data(CrmBeanUtil.copyList(list, SfaVisitStepStoreCheckRespVo.class))
                .count(page.getTotal())
                .build();

    }

    /**
     * 查询店面检查报表
     * @param req
     * @return
     */
    @EsDataPermission(userName = "userName.keyword", position = "posCode.keyword", org = "orgCode.keyword", customer = "clientCode.keyword")
    public PageResult<SfaVisitStepStoreCheckTableRespVo> findStoreCheckReportEsList(GetStoreCheckReq req){

//        //执行,返回包装结果的分页
//        org.springframework.data.domain.Page<SfaVisitStepStoreCheckEsData> list = this.sfaVisitStepStoreCheckEsDataRepositories.search(req.buildQuery());
//        List<SfaVisitStepStoreCheckTableRespVo> respVos = CrmBeanUtil.copyList(list.getContent(), SfaVisitStepStoreCheckTableRespVo.class);
//        respVos.forEach(o -> {
//            o.setClientTypeName(Objects.requireNonNull(SfaVisitRoleEnum.getSfaVisitRole(o.getClientType())).getDesc());
//        });
        if(StringUtils.isBlank(req.getStepCode())){
            throw new BusinessException("请指定步骤编码");
        }
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SfaVisitStepStoreCheckRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        SfaVisitStepStoreCheckReqVo reqVo = CrmBeanUtil.copy(req, SfaVisitStepStoreCheckReqVo.class);
        reqVo.setCheckTypeDesc(req.getClientTypeName());
        List<SfaVisitStepStoreCheckRespVo> list = this.sfaVisitStepStoreCheckMapper.findList(page, reqVo);
        return PageResult.<SfaVisitStepStoreCheckTableRespVo>builder()
                .data(CrmBeanUtil.copyList(list, SfaVisitStepStoreCheckTableRespVo.class))
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询店面检查报表详情
     * @param id
     * @return
     */
    public SfaVisitStepStoreCheckRespVo findStoreCheckReportDetailEs(String id){
//        BoolQueryBuilder builder = QueryBuilders.boolQuery();
//        builder.must(QueryBuilders.termQuery("id", id));
//        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
//        nativeSearchQueryBuilder.withQuery(builder);
//        NativeSearchQuery query = nativeSearchQueryBuilder.build();
//        Page<SfaVisitStepStoreCheckEsData> list = this.sfaVisitStepStoreCheckEsDataRepositories.search(query);
//        List<SfaVisitStepStoreCheckRespVo> result = CrmBeanUtil.copyList(list.getContent(), SfaVisitStepStoreCheckRespVo.class);
//        if (ObjectUtils.isEmpty(result)){
//            return new SfaVisitStepStoreCheckRespVo();
//        }
//        result.get(0).setClientTypeName(Objects.requireNonNull(SfaVisitRoleEnum.getSfaVisitRole(result.get(0).getClientType())).getDesc());
//        return result.get(0);

        SfaVisitStepStoreCheckEntity entity = this.sfaVisitStepStoreCheckMapper.selectById(id);
        if (ObjectUtils.isEmpty(entity)){
            return new SfaVisitStepStoreCheckRespVo();
        }
        SfaVisitStepStoreCheckRespVo respVo = CrmBeanUtil.copy(entity, SfaVisitStepStoreCheckRespVo.class);
        respVo.setRegularShelfDisplayList(CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal(), respVo.getId()), SfaAttachmentRespVo.class));
        respVo.setMaterialDisplayList(CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal(), respVo.getId()), SfaAttachmentRespVo.class));
        respVo.setPriceList(CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal(), respVo.getId()), SfaAttachmentRespVo.class));
        return respVo;
    }


}
