package com.biz.crm.visitstepdetail.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.visitstepdetail.req.SfaVisitStepStockInventoryReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.visitstep.req.GetStockInventoryTableReq;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 拜访步骤(库存盘点);
 * 
 * @author lf
 * @date 2020-12-29 11:35:55
 */
public interface SfaVisitStepStockInventoryMapper extends BaseMapper<SfaVisitStepStockInventoryEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitStepStockInventoryReqVo
     * @return
     */
    List<SfaVisitStepStockInventoryRespVo> findList(Page<SfaVisitStepStockInventoryRespVo> page, @Param("vo") SfaVisitStepStockInventoryReqVo sfaVisitStepStockInventoryReqVo);


    /**
     * 查询工作台-库存盘点信息列表
     * @param page
     * @param sfaVisitStepStockInventoryReqVo
     * @return
     */
    List<SfaVisitStepStockInventoryRespVo> findWorkStockList(Page<SfaVisitStepStockInventoryRespVo> page, @Param("vo") SfaVisitStepStockInventoryReqVo sfaVisitStepStockInventoryReqVo);

    /**
     * 查询库存明细报表
     * @param page
     * @param req
     * @return
     */
    @SqlPrivilege(posCode = "s.create_pos_code", orgCode = "s.create_org_code")
    List<SfaVisitStepStockInventoryRespVo> findStockInventoryReportList(Page<SfaVisitStepStockInventoryRespVo> page, @Param("vo") GetStockInventoryTableReq req);

    /**
     * 查询库存明细报表
     * @param page
     * @param clientCode
     * @return
     */
    List<SfaVisitStepStockInventoryRespVo> findStockInventoryReportListByClientCode(Page<SfaVisitStepStockInventoryRespVo> page, @Param("clientCode") String clientCode);

    /**
     * 查询最新的一条数据
     * @return
     */
    List<SfaVisitStepStockInventoryRespVo> findStockTimeAndClientCode(String clientCode);

}
