package com.biz.crm.visitstepdetail.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Mapping;

import javax.persistence.Index;

/**
 * 拜访步骤(库存盘点明细);实体类
 *
 * @author lf
 * @date 2021-01-12 22:41:49
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_stock_detail")
@CrmTable(name = "sfa_visit_step_stock_detail", tableNote = "拜访步骤(库存盘点明细);",indexes = {
        @Index(name = "visit_step_stock_detail_index1",columnList = "stock_inventory_id"),
        @Index(name = "visit_step_stock_detail_index2",columnList = "product_code")
})
public class SfaVisitStepStockDetailEntity extends CrmExtTenEntity<SfaVisitStepStockDetailEntity> {

    /**
     * 库存盘点id
     */
    @CrmColumn(name = "stock_inventory_id", length = 32, note = "库存盘点id")
    private String stockInventoryId;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 64, note = "产品名称")
    private String productName;

    /**
     * 系列编码
     */
    @CrmColumn(name = "product_level_code", length = 32, note = "系列编码")
    private String productLevelCode;

    /**
     * 系列名称
     */
    @CrmColumn(name = "product_level_name", length = 32, note = "系列名称")
    private String productLevelName;

    /**
     * 数量
     */
    @CrmColumn(name = "quantity",mysqlType = "int(9)", oracleType = "NUMBER(9,0)", note = "数量")
    private Integer quantity;

    /**
     * 单位
     */
    @CrmColumn(name = "sale_unit", length = 32, note = "单位")
    private String saleUnit;
    /**
     * 单位
     */
    @CrmColumn(name = "sale_unit_name", length = 32, note = "单位")
    private String saleUnitName;



//    @ApiModelProperty("盘库时间")
//    @Mapping(mappingPath = "es-mapping/date-time.json")
//    private String stockTime;


}
