package com.biz.crm.visitstepdetail.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.CrmObjTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import javax.persistence.Index;

/**
 * 拜访步骤(库存盘点);实体类
 *
 * @author lf
 * @date 2020-12-29 11:35:55
 */
@Getter
@Setter
@TableName(SfaVisitStepStockInventoryEntity.TABLE_NAME)
@CrmTable(name = SfaVisitStepStockInventoryEntity.TABLE_NAME, tableNote = "拜访步骤(库存盘点);"
        , indexes = {
        @Index(name = "visit_step_stock_inventory_index1", columnList = "step_code, client_code, pos_code, user_name, org_code"),
        @Index(name = "visit_step_stock_inventory_index2", columnList = "stock_date")}
        )
public class SfaVisitStepStockInventoryEntity extends CrmObjTenEntity<SfaVisitStepStockInventoryEntity> implements VisitStepListener.VisitStepListenerCommittedData {
    public static final String TABLE_NAME = "sfa_visit_step_stock_inventory";
    @CrmColumn(name = "redis_hash_key")
    private String redisHashKey;

    @ApiModelProperty("表单id")
    @CrmColumn(name = "form_id", length = 32, note = "表单id")
    @Field(type = FieldType.Keyword)
    private String formId;

    @CrmColumn(name = "visit_plan_info_id", length = 64, note = "拜访计划明细id")
    @Field(type = FieldType.Keyword)
    private String visitPlanInfoId;

    @ApiModelProperty("步骤编码")
    @CrmColumn(name = "step_code", length = 64, note = "步骤编码")
    private String stepCode;

    /**
     * 网点编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "网点名称")
    private String clientName;

    /**
     * 网点类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型")
    private String clientType;

    /**
     * 网点类型;协访网点类型
     */
    @ApiModelProperty("网点类型")
    @CrmColumn(name = "client_type_name", length = 32, note = "网点类型 协访网点类型")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 50, note = "人员姓名")
    private String realName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 50, note = "职位名称")
    private String posName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 50, note = "组织名称")
    private String orgName;

    /**
     * 盘库时间
     */
    @CrmColumn(name = "stock_time", length = 32, note = "盘库时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String stockTime;

    /**
     * 盘库时间
     */
    @CrmColumn(name = "stock_date", length = 16, note = "盘库日期")
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String stockDate;

    /**
     * 盘库时间
     */
    @CrmColumn(name = "stock_year_month", length = 8, note = "盘库年月")
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String stockYearMonth;

    /**
     * 盘库时间
     */
    @CrmColumn(name = "stock_year", length = 4, note = "盘库年份")
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String stockYear;
    
    /**
     * 盘库地址
     */
    @CrmColumn(name = "stock_address", length = 200, note = "盘库地址")
    private String stockAddress;

    /**
     * 经度
     */
    @CrmColumn(name = "longitude", length = 20, note = "活动编码")
    private String longitude;

    /**
     * 维度
     */
    @CrmColumn(name = "latitude", length = 20, note = "活动编码")
    private String latitude;

    /**
     * 网点id
     */
    @CrmColumn(name = "client_id", length = 40, note = "网点id")
    private String clientId;
}
