package com.biz.crm.visitstepdetail.model;

import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;

/**
 * 库存盘点ES执行数据对象
 *  @author: luoqi
 *  @Date: 2021-3-9 15:10
 *  @version: V1.0
 *  @Description:
 */
@Data
@Document(indexName = SfaVisitStepStockInventoryEsData.TABLE_NAME, type = SfaVisitStepStockInventoryEsData.TABLE_NAME)
public class SfaVisitStepStockInventoryEsData extends SfaVisitStepStockInventoryRedisData implements StepExecuteDataResp {
    /**
     * ES 索引
     */
    public final static String TABLE_NAME = "sfa_visit_step_stock_inventory_es_data";
    @ApiModelProperty("上次盘点提交时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String lastTime;

    @ApiModelProperty("表单配置")
    private SfaVisitStepFromRespVo sfaVisitStepFrom;
}
