package com.biz.crm.worksign.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

/**
 * 出差申请 
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Slf4j
@RestController
@RequestMapping("/sfatravel")
@Api(tags = "出差申请 ")
public class SfaTravelController {
    @Autowired
    private ISfaTravelService sfaTravelService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaTravelRespVo>> list(@RequestBody SfaTravelReqVo sfaTravelReqVo) {
        PageResult<SfaTravelRespVo> result=sfaTravelService.findList(sfaTravelReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaTravelRespVo> query(@RequestBody String id) {
        SfaTravelRespVo respVo=sfaTravelService.query(id);
        return Result.ok(respVo);
    }
}
