package com.biz.crm.worksign.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 考勤打卡记录表 
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@RestController
@RequestMapping("/sfaworksignrecord")
@Api(tags = "考勤打卡记录表 ")
public class SfaWorkSignRecordController {
    @Autowired
    private ISfaWorkSignRecordService sfaWorkSignRecordService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSignRecordRespVo>> list(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        PageResult<SfaWorkSignRecordRespVo> result=sfaWorkSignRecordService.findList(sfaWorkSignRecordReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSignRecordRespVo> query(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        SfaWorkSignRecordRespVo respVo=sfaWorkSignRecordService.query(sfaWorkSignRecordReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        sfaWorkSignRecordService.save(sfaWorkSignRecordReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        sfaWorkSignRecordService.update(sfaWorkSignRecordReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        sfaWorkSignRecordService.deleteBatch(sfaWorkSignRecordReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        sfaWorkSignRecordService.enableBatch(sfaWorkSignRecordReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        sfaWorkSignRecordService.disableBatch(sfaWorkSignRecordReqVo);
        return Result.ok("禁用成功");
    }
}
